/* ui_boxes.c - functions for generating pop-up windows
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank.h"

/* Global variables */
extern char *text;

/* External funcs and variables */
gint cb_abort(GtkWidget *widget, gpointer gdata);
void cb_ok_edit_source(GtkWidget *widget, gpointer gdata);

static void cb_close_dialog(GtkWidget *widget, gpointer data) {
    while (gtk_grab_get_current())
	gtk_grab_remove(gtk_grab_get_current());
}

/* An info box with text and an OK button */
GtkWidget *make_OK_box(const char *text) {
    GtkWidget *dialog;
    GtkWidget *button;
    GtkWidget *message;
    dialog  = gtk_dialog_new();
    gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
    gtk_signal_connect(GTK_OBJECT(dialog), "destroy", GTK_SIGNAL_FUNC(cb_close_dialog), NULL);
    button = gtk_button_new_with_label("OK");
    gtk_signal_connect_object(GTK_OBJECT(button),
			      "clicked",
			      (GtkSignalFunc) gtk_widget_destroy,
			      GTK_OBJECT(dialog));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);
    gtk_widget_show(button);
    message = gtk_label_new(text);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), message, FALSE, FALSE, 0);
    gtk_widget_show(message);
    gtk_grab_add(dialog);
    return dialog;
}
