/* $Id: xsh_detmon.h,v 1.22 2011-12-09 10:05:22 amodigli Exp $
 *
 * This file is part of the irplib package
 * Copyright (C) 2002, 2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1307 USA
 */

/*
 * $Author: amodigli $
 * $Date: 2011-12-09 10:05:22 $
 * $Revision: 1.22 $
 * $Name: not supported by cvs2svn $
 */

#ifndef XSH_DETMON_H
#define XSH_DETMON_H

/*----------------------------------------------------------------------------
                                   Includes
 ----------------------------------------------------------------------------*/

#include <cpl.h>
#include <xsh_cpl_size.h>
/*----------------------------------------------------------------------------
                                   Prototypes
 ----------------------------------------------------------------------------*/


#define NIR TRUE
#define OPT FALSE

#define DETMON_QC_FREQ       "ESO QC FREQ"
#define DETMON_QC_FREQ_C     "Spectrum frequency"

#define DETMON_QC_POW       "ESO QC POW"
#define DETMON_QC_POW_C     "Spectrum power"

#define DETMON_QC_DUTYCYCL       "ESO QC DUTYCYCL"
#define DETMON_QC_DUTYCYCL_C     "DUTYCYCL value (time to store a frame)"

#define DETMON_QC_MASTER_MEAN    "ESO QC MASTER MEAN"
#define DETMON_QC_MASTER_MEAN_C  "Master Mean value"

#define DETMON_QC_MASTER_RMS    "ESO QC MASTER RMS"
#define DETMON_QC_MASTER_RMS_C  "Master RMS value"

#define DETMON_QC_NBCOLDPIX    "ESO QC NBCOLPIX"
#define DETMON_QC_NBCOLDPIX_C  "Number of cold pixels"

#define DETMON_QC_NBHOTPIX    "ESO QC NBHOTPIX"
#define DETMON_QC_NBHOTPIX_C  "Number of hot pixels"

#define DETMON_QC_NBDEVPIX    "ESO QC NBDEVPIX"
#define DETMON_QC_NBDEVPIX_C  "Number of deviating pixels"

#define DETMON_QC_BIAS_RANDOM_VAL    "ESO QC BIAS RANDOM VAL"
#define DETMON_QC_BIAS_RANDOM_VAL_C  "Bias level (random sampling method) [ADU]"

#define DETMON_QC_BIAS_RANDOM_RON    "ESO QC BIAS RANDOM RON"
#define DETMON_QC_BIAS_RANDOM_RON_C  "Bias Read Out Noise (random sampling method) [ADU]"

#define DETMON_QC_BIAS_HISTO_VAL    "ESO QC BIAS HISTO VAL"
#define DETMON_QC_BIAS_HISTO_VAL_C  "Bias level (histogram method) [ADU]"

#define DETMON_QC_BIAS_HISTO_RON    "ESO QC BIAS HISTO RON"
#define DETMON_QC_BIAS_HISTO_RON_C  "Bias Read Out Noise (histogram method) [e- rms]"

#define DETMON_QC_BIAS_PRESCAN_MEAN    "ESO QC BIAS PRESCAN MEAN"
#define DETMON_QC_BIAS_PRESCAN_MEAN_C  "Bias mean level (on prescan region) [ADU]"

#define DETMON_QC_BIAS_PRESCAN_MED    "ESO QC BIAS PRESCAN MED"
#define DETMON_QC_BIAS_PRESCAN_MED_C  "Bias median level (on prescan region) [ADU]"

#define DETMON_QC_BIAS_PRESCAN_RON    "ESO QC BIAS PRESCAN RON"
#define DETMON_QC_BIAS_PRESCAN_RON_C  "Bias Read Out Noise (on prescan region) [e- rms]"


#define DETMON_QC_BIAS_OVERSCAN_MEAN    "ESO QC BIAS OVERSCAN MEAN"
#define DETMON_QC_BIAS_OVERSCAN_MEAN_C  "Bias mean level (on overscan region) [ADU]"

#define DETMON_QC_BIAS_OVERSCAN_MED    "ESO QC BIAS OVERSCAN MED"
#define DETMON_QC_BIAS_OVERSCAN_MED_C  "Bias median level (on overscan region) [ADU]"

#define DETMON_QC_BIAS_OVERSCAN_RON    "ESO QC BIAS OVERSCAN RON"
#define DETMON_QC_BIAS_OVERSCAN_RON_C  "Bias Read Out Noise (on overscan region) [e- rms]"

#define DETMON_QC_BIAS_REGION_VAL    "ESO QC BIAS REGION VAL"
#define DETMON_QC_BIAS_REGION_VAL_C  "Bias level (on user defined region) [ADU]"

#define DETMON_QC_BIAS_REGION_MED    "ESO QC BIAS REGION MED"
#define DETMON_QC_BIAS_REGION_MED_C  "Bias median level (on user defined region) [ADU]"

#define DETMON_QC_BIAS_REGION_RON    "ESO QC BIAS REGION RON"
#define DETMON_QC_BIAS_REGION_RON_C  "Bias Read Out Noise (on user defined region) [e- rms]"


#define DETMON_QC_DARK    "ESO QC DARK"
#define DETMON_QC_DARK_C  "Dark level [ADU]"

#define DETMON_QC_DARK_STDEV    "ESO QC DARK STDEV"
#define DETMON_QC_DARK_STDEV_C  "Dark stdev level [ADU]"



/* Macros to generate the recipe(s) description(s) */
#define xsh_detmon_ronbias_get_description(RECIPE_NAME, PIPE_NAME,          \
                                              DETMON_RONBIAS_RAW)              \
    RECIPE_NAME " -- " PIPE_NAME " ronbias recipe for OPT/IR.\n"            \
    "The files listed in the Set Of Frames must be tagged:\n"                  \
    "raw-file.fits  "DETMON_RONBIAS_RAW"\n"

#define xsh_detmon_pernoise_get_description(RECIPE_NAME, PIPE_NAME,         \
                                              DETMON_PERNOISE_RAW)             \
    RECIPE_NAME " -- " PIPE_NAME " Recipe for Periodic Noise Characterisation.\n"            \
    "The files listed in the Set Of Frames must be tagged:\n"                  \
    "raw-file.fits  "DETMON_PERNOISE_RAW"\n"

#define xsh_detmon_dark_get_description(RECIPE_NAME, PIPE_NAME,         \
                                              DETMON_DARK_RAW)             \
    RECIPE_NAME " -- " PIPE_NAME " Dark Recipe.\n"            \
    "The files listed in the Set Of Frames must be tagged:\n"                  \
    "raw-file.fits  "DETMON_DARK_RAW"\n"

#define RANDOM       ((irplib_ronbias_method) 1 << 1)
#define HISTO        ((irplib_ronbias_method) 1 << 2)
#define PREOVERSCAN  ((irplib_ronbias_method) 1 << 3)
#define REGION       ((irplib_ronbias_method) 1 << 4)

typedef unsigned long irplib_ronbias_method;

#undef REGEXP
#define REGEXP "ARCFILE|MJD-OBS|ESO TPL ID|DATE-OBS|ESO DET DIT|ESO DET NDIT"

#if defined CPL_VERSION_CODE && CPL_VERSION_CODE < CPL_VERSION(4, 2, 0) 

#define CPL_DFS_PRO_CATG     "ESO PRO CATG"
#define CPL_DFS_PRO_TYPE     "ESO PRO TYPE"
#define CPL_DFS_PRO_SCIENCE  "ESO PRO SCIENCE"
#define CPL_DFS_PRO_TECH     "ESO PRO TECH"

#endif

cpl_image * 
irplib_imagelist_collapse_stdev_create(const cpl_imagelist * imlist);

cpl_error_code
xsh_detmon_ronbias(cpl_frameset      *,
                      const cpl_parameterlist *,
                      const char        *,
                      const char        *,
                      const char        *,
                      const char        *,
		      const cpl_propertylist *,
		      const cpl_propertylist *,
		      const cpl_propertylist *,
		      const cpl_propertylist *,
		      const cpl_propertylist *,
		      const cpl_propertylist *,
		      const cpl_propertylist *,
                      const char        *,
                      int              (*)(const cpl_frame *,
                                           const cpl_frame *),
                      cpl_boolean);

cpl_propertylist *
xsh_detmon_fill_prolist(const char *,
			   const char *,
			   const char *,
			   cpl_boolean);

cpl_error_code
xsh_detmon_ronbias_fill_parlist_default(cpl_parameterlist *,
					   const char        *,
					   const char        *);

cpl_error_code
xsh_detmon_darkron_fill_parlist_default(cpl_parameterlist *,
					   const char        *,
					   const char        *);

cpl_error_code
xsh_detmon_ronbias_fill_parlist(cpl_parameterlist *,
				   const char *,
				   const char *,
				   const char *,
				   const char *,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const char *,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
				   const int,
                                   cpl_boolean);

cpl_error_code
xsh_detmon_ronbias_histo_reduce(const cpl_image * c_raw,
				   double * bias,
				   double * fwhm,
				   double * max);
cpl_image *
xsh_detmon_build_synthetic(cpl_image *,
                              cpl_image *);

cpl_error_code
xsh_flux_get_bias_window(const cpl_image *,
                            const int       *,
                            int              ,
                            int              ,
                            double          *,
                            double          *);

cpl_error_code
xsh_detmon_fill_pernoise_params(cpl_parameterlist *,
                                   const char *,
                                   const char *,
                                   int mode,
                                   const char *direction,
                                   double speed,
                                   int llx,
                                   int lly,
                                   int urx,
                                   int ury,
                                   double kappa,
                                   int exts);

int xsh_detmon_fill_pernoise_params_default(cpl_parameterlist        *,
                              const char        *,
                              const char        *);

cpl_error_code
xsh_detmon_pernoise(cpl_frameset      *,
                      const cpl_parameterlist *,
                      const char        *,
                      const char        *,
                      const char        *,
                      const char        *,
                      const char        *,
                      int              (*)(const cpl_frame *,
                                           const cpl_frame *));

cpl_table *
xsh_detmon_pernoise_reduce(cpl_image       *);

cpl_error_code
xsh_detmon_dark(cpl_frameset      *,
                   const cpl_parameterlist *,
                   const char        *,
                   const char        *,
                   const char        *,
                   const char        *,
                   const char        *,
                   const char        *,
                   const char        *,
                   int              (*)(const cpl_frame *,
                                        const cpl_frame *));

cpl_error_code
xsh_detmon_fill_dark_params(cpl_parameterlist * parlist,
                               const char *recipe_name,
                               const char *pipeline_name,
                               const char * ron_method,
                               const char * dsnu_method,
                               const char * optnir,
                               int exts);

int
xsh_detmon_fill_dark_params_default(cpl_parameterlist * parlist,
                                       const char *recipe_name,
                                       const char *pipeline_name);

int
xsh_detmon_compare_dits(const cpl_frame *, const cpl_frame *);

double                  irplib_pfits_get_exptime(const cpl_propertylist *);

cpl_error_code
xsh_detmon_fill_parlist(cpl_parameterlist *,
                           const char *, const char *, int, ...);

cpl_error_code
xsh_ksigma_clip(const cpl_image *,
		   const int,
		   const int,
		   const int,
		   const int,
		   const double,
		   const int,
		   const double,
		   double *,
		   double *);
int
xsh_detmon_retrieve_par_int(const char *,
                            const char *,
                            const char *, const cpl_parameterlist *);

double
xsh_detmon_retrieve_par_double(const char *,
                            const char *,
                            const char *, const cpl_parameterlist *);


#endif
