#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"

#define XF86Config4 "/etc/X11/XF86Config-4"
#define XF86Config "/etc/X11/XF86Config"

#define XFS_XTT "/etc/X11/xfs/config"

void add_path_x_4_config(gboolean is_xtt, gboolean is_font_path);
void add_path_x_3_config(gboolean is_font_path);

gboolean if_x_4;

/*
void modify_xfs_xtt(void)
{
	FILE *f_src;
	FILE *f;
	gchar str[STR_BUFFER_SIZE];
	gchar first_word[STR_BUFFER_SIZE];
	gchar temp_str[STR_BUFFER_SIZE];
	gint len, c;
	gchar *str_ptr;

	make_backup_file(XFS_XTT,"/etc/X11/xfs/config.cpanel");
	make_backup_file(XFS_XTT,"/tmp/xfs_config.tmp");

	f_src = fopen("/tmp/xfs_config.tmp","r");
	if(!f_src)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}

	f = fopen(XFS_XTT,"w");
	if(!f)
	{
		g_error("Error writing file %s.",XFS_XTT);
		exit(1);
	}

	while(fgets(str,STR_BUFFER_SIZE,f_src))
	{
		strcpy(temp_str,str);
		len = strlen(temp_str);
		c = 0;

*/
		/* skip space */

/*
		while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
		if(temp_str[c]=='#' || temp_str[c]=='\n')
		{
			fprintf(f,str);
			continue;
		}

		str_ptr = temp_str + c;
		while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
		temp_str[c] = '\0';

		strcpy(first_word,str_ptr);
		if(!strcasecmp(first_word,"deferglyphs"))
		{
			c++;
*/
			/* skip space */
/*
			while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='=' && temp_str[c]!='\n' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"all"))
				fprintf(f,"deferglyphs = 16\n");
			else
				fprintf(f,str);
		}
	}
	fclose(f);
	fclose(f_src);
}
*/


void modify_xftconfig(void)
{
	FILE *f_src;
	FILE *f;
	gchar str[STR_BUFFER_SIZE];
	gchar first_word[STR_BUFFER_SIZE];
	gchar temp_str[STR_BUFFER_SIZE];
	gint len, c;
	gchar *str_ptr;
	gboolean is_dir=0;

	make_backup_file("/etc/X11/XftConfig","/etc/X11/XftConfig.cpanel");
	make_backup_file("/etc/X11/XftConfig","/tmp/XftConfig.tmp");

	f_src = fopen("/tmp/XftConfig.tmp","r");
	if(!f_src)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}

	/* Check if the font path is already added */
	while(fgets(str,STR_BUFFER_SIZE,f_src))
	{
		strcpy(temp_str,str);
		len = strlen(temp_str);
		c = 0;

		/* skip space */
		while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
		if(temp_str[c]=='#' || temp_str[c]=='\n') continue;

		str_ptr = temp_str + c;
		while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
		temp_str[c] = '\0';

		strcpy(first_word,str_ptr);
		if(!strcasecmp(first_word,"dir"))
		{
			c++;
			/* skip space */
			while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"\"/usr/X11R6/lib/X11/fonts/TrueType\"") || !strcasecmp(first_word,"\"/usr/X11R6/lib/X11/fonts/TrueType/\""))
			{
				is_dir=1;
			}
		}
	}
	fclose(f_src);

	if(!is_dir)
	{
	make_backup_file("/etc/X11/XftConfig","/tmp/XftConfig.tmp");
	f_src = fopen("/tmp/XftConfig.tmp","r");
	if(!f_src)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}
	f = fopen("/etc/X11/XftConfig","w");
	if(!f)
	{
		g_error("Error writing file /etc/X11/XftConfig.");
		exit(1);
	}
	fprintf(f,"# The following line is added by CPanel\ndir \"/usr/X11R6/lib/X11/fonts/TrueType\"\n\n");

	while(fgets(str,STR_BUFFER_SIZE,f_src))
		fprintf(f,str);

	fclose(f_src);
	fclose(f);
	}
}


void add_path_x_4_config(gboolean is_xtt, gboolean is_fontpath)
{
	FILE *f_src;
	FILE *f;
	gchar str[STR_BUFFER_SIZE];
	gchar first_word[STR_BUFFER_SIZE];
	gchar temp_str[STR_BUFFER_SIZE];
	gchar path[STR_BUFFER_SIZE];
	gint len, c;
	gchar *str_ptr;

	if(isfile(XF86Config4))
	{
		make_backup_file(XF86Config4,"/tmp/XF86Config.tmp");
		make_backup_file(XF86Config4,"/etc/X11/XF86Config-4.cpanel");
		strcpy(path,XF86Config4);
	}
	else
	{
		make_backup_file(XF86Config,"/tmp/XF86Config.tmp");
		make_backup_file(XF86Config,"/etc/X11/XF86Config.cpanel");
		strcpy(path,XF86Config);
	}

	f_src = fopen("/tmp/XF86Config.tmp","r");
	if(!f_src)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}
	f = fopen(path,"w");
	if(!f)
	{
		g_error("Error writing file %s.",path);
		exit(1);
	}

	while(fgets(str,STR_BUFFER_SIZE,f_src))
	{
		strcpy(temp_str,str);
		len = strlen(temp_str);
		c = 0;

		/* skip space */
		while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
		if(temp_str[c]=='#' || temp_str[c]=='\n')
		{
			fprintf(f,str);
			continue;
		}

		str_ptr = temp_str + c;
		while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
		temp_str[c] = '\0';

		strcpy(first_word,str_ptr);
		if(!strcasecmp(first_word,"Section"))
		{
			c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"\"Module\""))
			{
				if(!is_xtt)
					fprintf(f,"Section \"Module\"\n\n# The following line is added by CPanel\nLoad        \"xtt\"\n");
			}
			else if(!strcasecmp(first_word,"\"Files\""))
			{
				if(!is_fontpath)
					fprintf(f,"Section \"Files\"\n\n# The following line is added by CPanel\nFontPath   \"/usr/X11R6/lib/X11/fonts/TrueType\"\n\n");
			}
			else
				fprintf(f,str);
		}
		else
			fprintf(f,str);
	}
	system("rm /tmp/XF86Config.tmp");
	fclose(f_src);
	fclose(f);
}

void modify_x_4_config(void)
{
	FILE *f_src;
	FILE *f;
	gchar str[STR_BUFFER_SIZE];
	gchar first_word[STR_BUFFER_SIZE];
	gchar temp_str[STR_BUFFER_SIZE];
	gchar path[STR_BUFFER_SIZE];
	gint len, c;
	gchar *str_ptr;
	gboolean is_xtt=0;
	gboolean is_fontpath=0;

	if(isfile(XF86Config4))
	{
		make_backup_file(XF86Config4,"/tmp/XF86Config.tmp");
		make_backup_file(XF86Config4,"/etc/X11/XF86Config-4.cpanel");
		strcpy(path,XF86Config4);
	}
	else
	{
		make_backup_file(XF86Config,"/tmp/XF86Config.tmp");
		make_backup_file(XF86Config,"/etc/X11/XF86Config.cpanel");
		strcpy(path,XF86Config);
	}

	f_src = fopen("/tmp/XF86Config.tmp","r");
	if(!f_src)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}
	f = fopen(path,"w");
	if(!f)
	{
		g_error("Error writing file %s.",path);
		exit(1);
	}

	while(fgets(str,STR_BUFFER_SIZE,f_src))
	{
		strcpy(temp_str,str);
		len = strlen(temp_str);
		c = 0;

		/* skip space */
		while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
		if(temp_str[c]=='#' || temp_str[c]=='\n')
		{
			fprintf(f,str);
			continue;
		}

		str_ptr = temp_str + c;
		while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
		temp_str[c] = '\0';

		strcpy(first_word,str_ptr);
		if(!strcasecmp(first_word,"Load"))
		{
			c++;
			/* skip space */
			while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"\"freetype\""))
				fprintf(f,"#    Load        \"freetype\"\n");
			else if(!strcasecmp(first_word,"\"xtt\""))
			{
				is_xtt = 1;
				fprintf(f,str);
			}
			else
				fprintf(f,str);
		}
		else if(!strcasecmp(first_word,"FontPath"))
		{
			c++;
			/* skip space */
			while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"\"/usr/X11R6/lib/X11/fonts/TrueType\"") || !strcasecmp(first_word,"\"/usr/X11R6/lib/X11/fonts/TrueType/\""))
			{
				is_fontpath = 1;
				fprintf(f,str);
			}
			else
				fprintf(f,str);
		}
		else
			fprintf(f,str);
	}
	system("rm /tmp/XF86Config.tmp");
	fclose(f_src);
	fclose(f);

	if(!is_xtt || !is_fontpath)
		add_path_x_4_config(is_xtt,is_fontpath);
}

void add_path_x_3_config(gboolean is_fontpath)
{
	FILE *f_src;
	FILE *f;
	gchar str[STR_BUFFER_SIZE];
	gchar first_word[STR_BUFFER_SIZE];
	gchar temp_str[STR_BUFFER_SIZE];
	gchar path[STR_BUFFER_SIZE];
	gint len, c;
	gchar *str_ptr;

	make_backup_file(XF86Config,"/tmp/XF86Config.tmp");
	make_backup_file(XF86Config,"/etc/X11/XF86Config.cpanel");
	strcpy(path,XF86Config);

	f_src = fopen("/tmp/XftConfig.tmp","r");
	if(!f_src)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}
	f = fopen(path,"w");
	if(!f)
	{
		g_error("Error writing file %s.",path);
		exit(1);
	}

	while(fgets(str,STR_BUFFER_SIZE,f_src))
	{
		strcpy(temp_str,str);
		len = strlen(temp_str);
		c = 0;

		/* skip space */
		while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
		if(temp_str[c]=='#' || temp_str[c]=='\n')
		{
			fprintf(f,str);
			continue;
		}

		str_ptr = temp_str + c;
		while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
		temp_str[c] = '\0';

		strcpy(first_word,str_ptr);
		if(!strcasecmp(first_word,"Section"))
		{
			c++;
			/* skip space */
			while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"\"Files\""))
			{
				if(!is_fontpath)
					fprintf(f,"Section \"Files\"\n\n# The ollowing line is added by CPanel\nFontPath   \"unix/:7100\"");
			}
			else
				fprintf(f,str);
		}
		else
			fprintf(f,str);
	}
	system("rm /tmp/XftConfig.tmp");
	fclose(f_src);
	fclose(f);
}

void modify_x_3_config(void)
{
	FILE *f_src;
	FILE *f;
	gchar str[STR_BUFFER_SIZE];
	gchar first_word[STR_BUFFER_SIZE];
	gchar temp_str[STR_BUFFER_SIZE];
	gchar path[STR_BUFFER_SIZE];
	gint len, c;
	gchar *str_ptr;
	gboolean is_fontpath=0;

	make_backup_file(XF86Config,"/tmp/XF86Config.tmp");
	make_backup_file(XF86Config,"/etc/X11/XF86Config.cpanel");
	strcpy(path,XF86Config);

	f_src = fopen("/tmp/XF86Config.tmp","r");
	if(!f_src)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}
	f = fopen(path,"w");
	if(!f)
	{
		g_error("Error writing file %s.",path);
		exit(1);
	}

	while(fgets(str,STR_BUFFER_SIZE,f_src))
	{
		strcpy(temp_str,str);
		len = strlen(temp_str);
		c = 0;

		/* skip space */
		while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
		if(temp_str[c]=='#' || temp_str[c]=='\n')
		{
			fprintf(f,str);
			continue;
		}

		str_ptr = temp_str + c;
		while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
		temp_str[c] = '\0';

		strcpy(first_word,str_ptr);
		if(!strcasecmp(first_word,"FontPath"))
		{
			c++;
			/* skip space */
			while((temp_str[c]==' ' || temp_str[c]=='\t') && c<len) c++;
			str_ptr = temp_str + c;
			while(temp_str[c]!=' ' && temp_str[c]!='\t' && temp_str[c]!='\n' && c<len) c++;
			temp_str[c] = '\0';
			strcpy(first_word,str_ptr);
			if(!strcasecmp(first_word,"\"unix/:7100\"") || !strcasecmp(first_word,"\"unix/localhost:7100\""))
			{
				is_fontpath = 1;
				fprintf(f,str);
			}
			else
				fprintf(f,str);
		}
		else
			fprintf(f,str);
	}
	system("rm /tmp/XF86Config.tmp");
	fclose(f_src);
	fclose(f);

	if(!is_fontpath)
		add_path_x_3_config(is_fontpath);
}


gboolean check_if_xfs_xtt(void)
{
	FILE *f;
	gchar *str;
	gboolean return_value;

	if((str = (gchar *)malloc(sizeof(gchar)*200))==NULL)
	{
		g_error("Error allocating memory.. Memory not enough?");
		exit(1);
	}

	system("dpkg -l xfs-xtt > /tmp/dpkg.xfs-xtt");

	if((f=fopen("/tmp/dpkg.xfs-xtt","r"))==NULL)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}

	if(*(str+1)=='i')
		return_value =  1;
	else
		return_value = 0;

	system("rm /tmp/dpkg.xfs-xtt");

	fclose(f);
	return return_value;
}

gboolean check_if_x_4(void)
{
	FILE *f;
	gchar *str;
	gint c;
	gboolean return_value;
	
	if((str = (gchar *)malloc(sizeof(gchar)*200))==NULL)
	{
		g_error("Error allocating memory.. Memory not enough?");
		exit(1);
	}

	system("ls -l /etc/X11/X > /tmp/ver.x.cpanel");

	if((f=fopen("/tmp/ver.x.cpanel","r"))==NULL)
	{
		g_error("Error creating temp file. Is your /tmp full?");
		exit(1);
	}

	fgets(str,sizeof(gchar)*200,f);

	c = strlen(str);
	c -= 8;

	system("rm /tmp/ver.x.cpanel");

	if(!strcasecmp((str+c),"XFree86\n"))
		return_value = 1;
	else
		return_value = 0;

	fclose(f);
	return return_value;
}

void x3config(GtkWidget *pre_button, gpointer data)
{
	modify_x_3_config();
//	modify_xfs_xtt();

	simple_message_dialog(_("Operation Complete!\nCaution! Please use \"startx -- -deferglyphs 16\" to start X-window\nPlease restart X-window now or it will not take effect"),_("Close"));
}

void x4config(GtkWidget *pre_button, gpointer data)
{
	modify_x_4_config();
	modify_xftconfig();

	simple_message_dialog(_("Operation Complete!\nPlease restart X-window or it will not take effect"),_("Close"));
}


void xtt_config(GtkWidget *pre_button, gpointer data)
{
	gboolean if_x_4;
	gboolean if_xfs_xtt;
	GtkWidget *label;
	GtkWidget *dialog;
	GtkWidget *button;

	if_x_4 = check_if_x_4();
	if_xfs_xtt = check_if_xfs_xtt();

	if(!if_x_4 && !if_xfs_xtt)
	{
		dialog = gtk_dialog_new();

		label = gtk_label_new(_("Since you're not using X-Window version 4.0 or later\nYou've to install xfs-xtt in order to complete this task.\nIf you're sure you've install X-Window 4.0 or later,\nYou may have to re-configure your X and\nchange the simbolic link /etc/X to /usr/X11R6/bin/Xfree86"));

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,5);

		button = gtk_button_new_with_label(_("Install xfs-xtt now"));

		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(apt_process),"xfs-xtt");
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(close_win),dialog);

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,TRUE,TRUE,0);

		GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);

		button = gtk_button_new_with_label(_("OK"));

		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(close_win),dialog);

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,TRUE,TRUE,0);

		GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);

		gtk_widget_grab_default(button);

		gtk_grab_add(dialog);
		gtk_widget_show_all(dialog);
	}
	else if(!if_x_4)
	{
		dialog = gtk_dialog_new();

		label = gtk_label_new(_("You are using X-Windows version 3.3.x (stable release)"));

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,5);

		label = gtk_label_new(_("You have xfs-xtt font server installed"));

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,5);

		label = gtk_label_new(_("Do you want to continue?"));
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,8);

		button = gtk_button_new_with_label(_("Yes"));
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(x3config),NULL);
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(close_win),dialog);
		GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,TRUE,TRUE,0);
		button = gtk_button_new_with_label(_("No"));
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(close_win),dialog);
		GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,TRUE,TRUE,0);

		gtk_widget_grab_default(button);

		gtk_grab_add(dialog);
		gtk_widget_show_all(dialog);
	}
	else
	{
		dialog = gtk_dialog_new();

		label = gtk_label_new(_("You are using X-Windows version 4.0 or later"));

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,5);

		if(if_xfs_xtt)
			label = gtk_label_new(_("You have xfs-xtt font server installed"));
		else
			label = gtk_label_new(_("You don't have xfs-xtt font server installed"));

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,5);

		label = gtk_label_new(_("Do you want to continue?"));
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,8);

		button = gtk_button_new_with_label(_("Yes"));
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(x4config),NULL);
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(close_win),dialog);
		GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,TRUE,TRUE,0);
		button = gtk_button_new_with_label(_("No"));
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(close_win),dialog);
		GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,TRUE,TRUE,0);

		gtk_widget_grab_default(button);

		gtk_grab_add(dialog);

		gtk_widget_show_all(dialog);
	}
}
