#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <netdb.h>

#include <sys/socket.h>
#include <resolv.h>
#include "cpanel.h"


#define MAXBUF 1024

gchar *query_server_msg(gint port, gchar *addr)
{
	int sockfd;
	struct sockaddr_in dest;
	gchar buffer[MAXBUF];
	gchar *server_msg;

	gchar ip[16];
	struct hostent *answer;
	struct in_addr **addrptr;

	answer = gethostbyname(addr);

	if(!answer)
	{
		fprintf(stderr, "Cannot resolve the hostname %s\n",addr);
		return 0;
	}

	addrptr = (struct in_addr **) answer->h_addr_list;
	sprintf(ip,"%s",inet_ntoa(**addrptr));
	
	server_msg = (gchar *)malloc(sizeof(gchar)*MAXBUF);

	if((sockfd = socket(AF_INET,SOCK_STREAM,0))<0)
	{
		fprintf(stderr,"Error connecting server %s:%d\n",ip,port);
		return "0";
	}

	bzero(&dest, sizeof(dest));
	dest.sin_family = AF_INET;
	dest.sin_port = htons(port);
	if( inet_aton(ip, &dest.sin_addr.s_addr) == 0)
	{
		fprintf(stderr,"Error connecting server %s:%d\n",ip,port);
		return "0";
	}

	if(connect(sockfd, &dest, sizeof(dest)) !=0 )
	{
		fprintf(stderr,"Error connecting server %s:%d\n",ip,port);
		return "0";
	}

	bzero(buffer,MAXBUF);
	recv(sockfd,buffer, sizeof(buffer),0);
	close(sockfd);

	strcpy(server_msg,buffer);

	return server_msg;
}
