/*****************************************************************
 *
 *   menu.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#include "cpanel.h"
#include "defaults.h"
#include <stdio.h>

extern gboolean if_gb;
extern gboolean if_float;
extern gboolean if_root;
extern gint coord_x;
extern gint coord_y;

gboolean temp_float;
GtkWidget *entry_coord[2];

GtkWidget *create_menu(GtkWidget *menu, gchar *label);

void trad_selected(GtkWidget *button, gpointer data)
{
	if_gb = 0;
}

void simp_selected(GtkWidget *button, gpointer data)
{
	if_gb = 1;
}

void show_note(GtkWidget *button, gpointer data)
{
	simple_message_dialog(_("Please set locale again and restart CPanel"),_("Close"));
}

void show_hints(GtkWidget *button, gpointer *data)
{
	show_help("cpanel_help",_("Welcome to CPanel"),600,400);
}

void ok_pref(GtkWidget *button, gpointer *data)
{
	coord_x = atof(gtk_entry_get_text(GTK_ENTRY(entry_coord[0])));
	coord_y = atof(gtk_entry_get_text(GTK_ENTRY(entry_coord[1])));
	if_float = temp_float;
}

void use_float(GtkWidget *check_button, gpointer *data)
{
	if(!if_float)
		temp_float=1;
	else
		temp_float=0;
}

void preference(GtkWidget *menu, gpointer *data)
{
	GtkWidget *dialog;
	GtkWidget *button;
	GtkWidget *check_button;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *options;
	gchar *str_x;
	gchar *str_y;

temp_float = if_float;

	dialog = gtk_dialog_new();
	
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
			GTK_SIGNAL_FUNC(close_win),dialog);

	gtk_window_set_title(GTK_WINDOW(dialog),_("Options"));
	gtk_container_set_border_width(GTK_CONTAINER(dialog),5);

	/* making a check option */
	check_button = make_check_opt(_("Use floating tools tar"),if_float);
	gtk_signal_connect(GTK_OBJECT(check_button),"toggled",
			GTK_SIGNAL_FUNC(use_float),NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
			check_button,TRUE,TRUE,1);
	/* getting x, y coordinates */
	str_x = malloc(10*sizeof(char));
	str_y = malloc(10*sizeof(char));
	sprintf(str_x,"%d",coord_x);
	sprintf(str_y,"%d",coord_y);
	options = make_opt(_("X Coordinate: "),entry_coord,0,str_x);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
			options,TRUE,TRUE,1);
	options = make_opt(_("Y Coordinate: "),entry_coord,1,str_y);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
			options,TRUE,TRUE,1);

	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),dialog);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area),
			button,TRUE,TRUE,0);

	button = gtk_button_new_with_label(_("OK"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(ok_pref),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),dialog);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area),
			button,TRUE,TRUE,0);

	gtk_widget_grab_default(button);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
}

void select_lang(GtkWidget *ment_item, gpointer data)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *radio;
	GSList *group = NULL;

	win = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(win),_("Select Language"));
	gtk_container_set_border_width(GTK_CONTAINER(win),10);

	radio = gtk_radio_button_new_with_label(group,_("Traditional Chinese"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
	gtk_signal_connect(GTK_OBJECT(radio),"toggled",
			GTK_SIGNAL_FUNC(trad_selected),NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),radio,FALSE,FALSE,5);
	if(!if_gb)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio),TRUE);

	radio = gtk_radio_button_new_with_label(group,_("Simplified Chinese"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
	gtk_signal_connect(GTK_OBJECT(radio),"toggled",
			GTK_SIGNAL_FUNC(simp_selected),NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),radio,FALSE,FALSE,5);
	if(if_gb)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio),TRUE);

	button = gtk_button_new_with_label(_("Close"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(radio),"clicked",
			GTK_SIGNAL_FUNC(show_note),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,2);
	gtk_widget_grab_default(button);

	gtk_widget_show_all(win);
}

GtkWidget *cpanel_create_menu_bar(void)
{
	GtkWidget *menu_bar;
	GtkWidget *menu;
	GtkWidget *menu_item;

	menu_bar = gtk_menu_bar_new();

	/* Program */
	menu_item = gtk_menu_item_new_with_label(_("Program"));
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_item);

	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item),menu);

	if(if_root)
	{
	menu_item = create_menu(menu, _("Smart Update"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(apt_process),"cpanel");
	}

	if(if_root)
	{
	menu_item = create_menu(menu, _("Install New Programs"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(install_list),NULL);
	}

	menu_item = create_menu(menu, _("Quit"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(save_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(gtk_exit),NULL);

	/* Setting */
	menu_item = gtk_menu_item_new_with_label(_("Setting"));
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_item);

	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item),menu);

	menu_item = create_menu(menu, _("Select Language"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(select_lang),NULL);

	menu_item = create_menu(menu, _("Preference"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(preference),NULL);

	/* Help */
	menu_item = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_item);

	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item),menu);

	menu_item = create_menu(menu, _("System Check"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(sys_info_page),NULL);

	menu_item = create_menu(menu, _("Hints"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(show_hints),NULL);

	menu_item = create_menu(menu, _("About"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(display_about_page),NULL);


	return menu_bar;
}


GtkWidget *create_menu(GtkWidget *menu, gchar *label)
{
	GtkWidget *menu_item;

	menu_item = gtk_menu_item_new_with_label(label);
	gtk_menu_append(GTK_MENU(menu),menu_item);

	return menu_item;
}
