#ifndef __GENPROF_H__
#define __GENPROF_H__

/*
 Copyright (c) 2006-2010 Trevor Williams

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with this program;
 if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*!
 \file    genprof.h
 \author  Trevor Williams  (phase1geo@gmail.com)
 \date    12/10/2007
*/

#include "defines.h"

#define NUM_PROFILES 1060

#ifdef DEBUG
#define UNREGISTERED 0
#define INSTANCE_DISPLAY_TREE_HELPER 1
#define INSTANCE_DISPLAY_TREE 2
#define INSTANCE_CREATE 3
#define INSTANCE_GEN_SCOPE 4
#define INSTANCE_COMPARE 5
#define INSTANCE_FIND_SCOPE 6
#define INSTANCE_FIND_BY_FUNIT 7
#define INSTANCE_FIND_BY_FUNIT_NAME_IF_ONE_HELPER 8
#define INSTANCE_FIND_BY_FUNIT_NAME_IF_ONE 9
#define INSTANCE_FIND_SIGNAL_BY_EXCLUSION_ID 10
#define INSTANCE_FIND_EXPRESSION_BY_EXCLUSION_ID 11
#define INSTANCE_FIND_FSM_ARC_INDEX_BY_EXCLUSION_ID 12
#define INSTANCE_ADD_CHILD 13
#define INSTANCE_COPY_HELPER 14
#define INSTANCE_COPY 15
#define INSTANCE_PARSE_ADD 16
#define INSTANCE_RESOLVE_INST 17
#define INSTANCE_RESOLVE_HELPER 18
#define INSTANCE_RESOLVE 19
#define INSTANCE_READ_ADD 20
#define INSTANCE_MERGE 21
#define INSTANCE_GET_LEADING_HIERARCHY 22
#define INSTANCE_MARK_LHIER_DIFFS 23
#define INSTANCE_MERGE_TWO_TREES 24
#define INSTANCE_DB_WRITE 25
#define INSTANCE_ONLY_DB_READ 26
#define INSTANCE_ONLY_DB_MERGE 27
#define INSTANCE_REMOVE_STMT_BLKS_CALLING_STMT 28
#define INSTANCE_REMOVE_PARMS_WITH_EXPR 29
#define INSTANCE_DEALLOC_SINGLE 30
#define INSTANCE_OUTPUT_DUMPVARS 31
#define INSTANCE_DEALLOC_TREE 32
#define INSTANCE_DEALLOC 33
#define STATEMENT_CREATE 34
#define STATEMENT_QUEUE_ADD 35
#define STATEMENT_QUEUE_COMPARE 36
#define STATEMENT_SIZE_ELEMENTS 37
#define STATEMENT_DB_WRITE 38
#define STATEMENT_DB_WRITE_TREE 39
#define STATEMENT_DB_WRITE_EXPR_TREE 40
#define STATEMENT_DB_READ 41
#define STATEMENT_ASSIGN_EXPR_IDS 42
#define STATEMENT_CONNECT 43
#define STATEMENT_GET_LAST_LINE_HELPER 44
#define STATEMENT_GET_LAST_LINE 45
#define STATEMENT_FIND_RHS_SIGS 46
#define STATEMENT_FIND_STATEMENT 47
#define STATEMENT_CONTAINS_EXPR_CALLING_STMT 48
#define STATEMENT_DEALLOC_RECURSIVE 49
#define STATEMENT_DEALLOC 50
#define RANK_CREATE_COMP_CDD_COV 51
#define RANK_DEALLOC_COMP_CDD_COV 52
#define RANK_CHECK_INDEX 53
#define RANK_GATHER_SIGNAL_COV 54
#define RANK_GATHER_COMB_COV 55
#define RANK_GATHER_EXPRESSION_COV 56
#define RANK_GATHER_FSM_COV 57
#define RANK_CALC_NUM_CPS 58
#define RANK_GATHER_COMP_CDD_COV 59
#define RANK_READ_CDD 60
#define RANK_SELECTED_CDD_COV 61
#define RANK_PERFORM_WEIGHTED_SELECTION 62
#define RANK_PERFORM_GREEDY_SORT 63
#define RANK_COUNT_CPS 64
#define RANK_PERFORM 65
#define RANK_OUTPUT 66
#define COMMAND_RANK 67
#define LEXER_KEYWORD_SYS_SV_CODE 68
#define RACE_BLK_CREATE 69
#define RACE_FIND_HEAD_STATEMENT_CONTAINING_STATEMENT_HELPER 70
#define RACE_FIND_HEAD_STATEMENT_CONTAINING_STATEMENT 71
#define RACE_GET_HEAD_STATEMENT 72
#define RACE_FIND_HEAD_STATEMENT 73
#define RACE_CALC_STMT_BLK_TYPE 74
#define RACE_CALC_EXPR_ASSIGNMENT 75
#define RACE_CALC_ASSIGNMENTS 76
#define RACE_HANDLE_RACE_CONDITION 77
#define RACE_CHECK_ASSIGNMENT_TYPES 78
#define RACE_CHECK_ONE_BLOCK_ASSIGNMENT 79
#define RACE_CHECK_RACE_COUNT 80
#define RACE_CHECK_MODULES 81
#define RACE_DB_WRITE 82
#define RACE_DB_READ 83
#define RACE_GET_STATS 84
#define RACE_REPORT_SUMMARY 85
#define RACE_REPORT_VERBOSE 86
#define RACE_REPORT 87
#define RACE_COLLECT_LINES 88
#define RACE_BLK_DELETE_LIST 89
#define SEARCH_INIT 90
#define SEARCH_ADD_INCLUDE_PATH 91
#define SEARCH_ADD_DIRECTORY_PATH 92
#define SEARCH_ADD_FILE 93
#define SEARCH_ADD_NO_SCORE_FUNIT 94
#define SEARCH_ADD_EXTENSIONS 95
#define SEARCH_FREE_LISTS 96
#define SYS_TASK_UNIFORM 97
#define SYS_TASK_RTL_DIST_UNIFORM 98
#define SYS_TASK_SRANDOM 99
#define SYS_TASK_RANDOM 100
#define SYS_TASK_URANDOM 101
#define SYS_TASK_URANDOM_RANGE 102
#define SYS_TASK_REALTOBITS 103
#define SYS_TASK_BITSTOREAL 104
#define SYS_TASK_SHORTREALTOBITS 105
#define SYS_TASK_BITSTOSHORTREAL 106
#define SYS_TASK_ITOR 107
#define SYS_TASK_RTOI 108
#define SYS_TASK_CLOG2 109
#define SYS_TASK_STORE_PLUSARGS 110
#define SYS_TASK_TEST_PLUSARG 111
#define SYS_TASK_VALUE_PLUSARGS 112
#define SYS_TASK_DEALLOC 113
#define LXT2_RD_EXPAND_INTEGER_TO_BITS 114
#define LXT2_RD_EXPAND_BITS_TO_INTEGER 115
#define LXT2_RD_ITER_RADIX 116
#define LXT2_RD_ITER_RADIX0 117
#define LXT2_RD_BUILD_RADIX 118
#define LXT2_RD_REGENERATE_PROCESS_MASK 119
#define LXT2_RD_PROCESS_BLOCK 120
#define LXT2_RD_INIT 121
#define LXT2_RD_CLOSE 122
#define LXT2_RD_GET_FACNAME 123
#define LXT2_RD_ITER_BLOCKS 124
#define LXT2_RD_LIMIT_TIME_RANGE 125
#define LXT2_RD_UNLIMIT_TIME_RANGE 126
#define PERF_GEN_STATS 127
#define PERF_OUTPUT_MOD_STATS 128
#define PERF_OUTPUT_INST_REPORT_HELPER 129
#define PERF_OUTPUT_INST_REPORT 130
#define TCL_FUNC_GET_RACE_REASON_MSGS 131
#define TCL_FUNC_GET_FUNIT_LIST 132
#define TCL_FUNC_GET_INSTANCES 133
#define TCL_FUNC_GET_INSTANCE_LIST 134
#define TCL_FUNC_IS_FUNIT 135
#define TCL_FUNC_GET_FUNIT 136
#define TCL_FUNC_GET_INST 137
#define TCL_FUNC_GET_FUNIT_NAME 138
#define TCL_FUNC_GET_FILENAME 139
#define TCL_FUNC_INST_SCOPE 140
#define TCL_FUNC_GET_FUNIT_START_AND_END 141
#define TCL_FUNC_COLLECT_UNCOVERED_LINES 142
#define TCL_FUNC_COLLECT_COVERED_LINES 143
#define TCL_FUNC_COLLECT_RACE_LINES 144
#define TCL_FUNC_COLLECT_UNCOVERED_TOGGLES 145
#define TCL_FUNC_COLLECT_COVERED_TOGGLES 146
#define TCL_FUNC_COLLECT_UNCOVERED_MEMORIES 147
#define TCL_FUNC_COLLECT_COVERED_MEMORIES 148
#define TCL_FUNC_GET_TOGGLE_COVERAGE 149
#define TCL_FUNC_GET_MEMORY_COVERAGE 150
#define TCL_FUNC_COLLECT_UNCOVERED_COMBS 151
#define TCL_FUNC_COLLECT_COVERED_COMBS 152
#define TCL_FUNC_GET_COMB_EXPRESSION 153
#define TCL_FUNC_GET_COMB_COVERAGE 154
#define TCL_FUNC_COLLECT_UNCOVERED_FSMS 155
#define TCL_FUNC_COLLECT_COVERED_FSMS 156
#define TCL_FUNC_GET_FSM_COVERAGE 157
#define TCL_FUNC_COLLECT_UNCOVERED_ASSERTIONS 158
#define TCL_FUNC_COLLECT_COVERED_ASSERTIONS 159
#define TCL_FUNC_GET_ASSERT_COVERAGE 160
#define TCL_FUNC_OPEN_CDD 161
#define TCL_FUNC_CLOSE_CDD 162
#define TCL_FUNC_SAVE_CDD 163
#define TCL_FUNC_MERGE_CDD 164
#define TCL_FUNC_GET_LINE_SUMMARY 165
#define TCL_FUNC_GET_TOGGLE_SUMMARY 166
#define TCL_FUNC_GET_MEMORY_SUMMARY 167
#define TCL_FUNC_GET_COMB_SUMMARY 168
#define TCL_FUNC_GET_FSM_SUMMARY 169
#define TCL_FUNC_GET_ASSERT_SUMMARY 170
#define TCL_FUNC_PREPROCESS_VERILOG 171
#define TCL_FUNC_GET_SCORE_PATH 172
#define TCL_FUNC_GET_INCLUDE_PATHNAME 173
#define TCL_FUNC_GET_GENERATION 174
#define TCL_FUNC_SET_LINE_EXCLUDE 175
#define TCL_FUNC_SET_TOGGLE_EXCLUDE 176
#define TCL_FUNC_SET_MEMORY_EXCLUDE 177
#define TCL_FUNC_SET_COMB_EXCLUDE 178
#define TCL_FUNC_FSM_EXCLUDE 179
#define TCL_FUNC_SET_ASSERT_EXCLUDE 180
#define TCL_FUNC_GENERATE_REPORT 181
#define TCL_FUNC_INITIALIZE 182
#define COMBINATION_CALC_DEPTH 183
#define COMBINATION_DOES_MULTI_EXP_NEED_UL 184
#define COMBINATION_MULTI_EXPR_CALC 185
#define COMBINATION_IS_EXPR_MULTI_NODE 186
#define COMBINATION_GET_TREE_STATS 187
#define COMBINATION_RESET_COUNTED_EXPRS 188
#define COMBINATION_RESET_COUNTED_EXPR_TREE 189
#define COMBINATION_GET_STATS 190
#define COMBINATION_GET_FUNIT_SUMMARY 191
#define COMBINATION_GET_INST_SUMMARY 192
#define COMBINATION_DISPLAY_INSTANCE_SUMMARY 193
#define COMBINATION_INSTANCE_SUMMARY 194
#define COMBINATION_DISPLAY_FUNIT_SUMMARY 195
#define COMBINATION_FUNIT_SUMMARY 196
#define COMBINATION_DRAW_LINE 197
#define COMBINATION_DRAW_CENTERED_LINE 198
#define COMBINATION_PARENTHESIZE 199
#define COMBINATION_UNDERLINE_TREE 200
#define COMBINATION_PREP_LINE 201
#define COMBINATION_UNDERLINE 202
#define COMBINATION_UNARY 203
#define COMBINATION_EVENT 204
#define COMBINATION_TWO_VARS 205
#define COMBINATION_MULTI_VAR_EXPRS 206
#define COMBINATION_MULTI_EXPR_OUTPUT_LENGTH 207
#define COMBINATION_MULTI_EXPR_OUTPUT 208
#define COMBINATION_MULTI_VARS 209
#define COMBINATION_GET_MISSED_EXPR 210
#define COMBINATION_LIST_MISSED 211
#define COMBINATION_OUTPUT_EXPR 212
#define COMBINATION_DISPLAY_VERBOSE 213
#define COMBINATION_INSTANCE_VERBOSE 214
#define COMBINATION_FUNIT_VERBOSE 215
#define COMBINATION_COLLECT 216
#define COMBINATION_GET_EXCLUDE_LIST 217
#define COMBINATION_GET_EXPRESSION 218
#define COMBINATION_GET_COVERAGE 219
#define COMBINATION_REPORT 220
#define REPORT_PARSE_METRICS 221
#define REPORT_PARSE_ARGS 222
#define REPORT_GATHER_INSTANCE_STATS 223
#define REPORT_GATHER_FUNIT_STATS 224
#define REPORT_PRINT_HEADER 225
#define REPORT_GENERATE 226
#define REPORT_READ_CDD_AND_READY 227
#define REPORT_CLOSE_CDD 228
#define REPORT_SAVE_CDD 229
#define REPORT_FORMAT_EXCLUSION_REASON 230
#define REPORT_OUTPUT_EXCLUSION_REASON 231
#define COMMAND_REPORT 232
#define OVL_IS_ASSERTION_NAME 233
#define OVL_IS_ASSERTION_MODULE 234
#define OVL_IS_COVERAGE_POINT 235
#define OVL_ADD_ASSERTIONS_TO_NO_SCORE_LIST 236
#define OVL_GET_FUNIT_STATS 237
#define OVL_GET_COVERAGE_POINT 238
#define OVL_DISPLAY_VERBOSE 239
#define OVL_COLLECT 240
#define OVL_GET_COVERAGE 241
#define SIM_CURRENT_THREAD 242
#define SIM_THREAD_POP_HEAD 243
#define SIM_THREAD_INSERT_INTO_DELAY_QUEUE 244
#define SIM_THREAD_PUSH 245
#define SIM_EXPR_CHANGED 246
#define SIM_CREATE_THREAD 247
#define SIM_ADD_THREAD 248
#define SIM_KILL_THREAD 249
#define SIM_KILL_THREAD_WITH_FUNIT 250
#define SIM_ADD_STATICS 251
#define SIM_EXPRESSION 252
#define SIM_THREAD 253
#define SIM_SIMULATE 254
#define SIM_INITIALIZE 255
#define SIM_STOP 256
#define SIM_FINISH 257
#define SIM_ADD_NONBLOCK_ASSIGN 258
#define SIM_PERFORM_NBA 259
#define SIM_DEALLOC 260
#define VCDID 261
#define VCD_CALLBACK 262
#define LXT_PARSE 263
#define VCD_PARSE_DEF_IGNORE 264
#define VCD_PARSE_DEF_VAR 265
#define VCD_PARSE_DEF_SCOPE 266
#define VCD_PARSE_DEF 267
#define VCD_PARSE_SIM_VECTOR 268
#define VCD_PARSE_SIM_REAL 269
#define VCD_PARSE_SIM_IGNORE 270
#define VCD_PARSE_SIM 271
#define VCD_PARSE 272
#define SCORE_GENERATE_TOP_VPI_MODULE 273
#define SCORE_GENERATE_TOP_DUMPVARS_MODULE 274
#define SCORE_GENERATE_PLI_TAB_FILE 275
#define SCORE_PARSE_DEFINE 276
#define SCORE_PARSE_ARGS 277
#define COMMAND_SCORE 278
#define FSM_CREATE 279
#define FSM_ADD_ARC 280
#define FSM_CREATE_TABLES 281
#define FSM_DB_WRITE 282
#define FSM_DB_READ 283
#define FSM_DB_MERGE 284
#define FSM_MERGE 285
#define FSM_TABLE_SET 286
#define FSM_GET_STATS 287
#define FSM_GET_FUNIT_SUMMARY 288
#define FSM_GET_INST_SUMMARY 289
#define FSM_GATHER_SIGNALS 290
#define FSM_COLLECT 291
#define FSM_GET_COVERAGE 292
#define FSM_DISPLAY_INSTANCE_SUMMARY 293
#define FSM_INSTANCE_SUMMARY 294
#define FSM_DISPLAY_FUNIT_SUMMARY 295
#define FSM_FUNIT_SUMMARY 296
#define FSM_DISPLAY_STATE_VERBOSE 297
#define FSM_DISPLAY_ARC_VERBOSE 298
#define FSM_DISPLAY_VERBOSE 299
#define FSM_INSTANCE_VERBOSE 300
#define FSM_FUNIT_VERBOSE 301
#define FSM_REPORT 302
#define FSM_DEALLOC 303
#define LEXER_KEYWORD_SYS_1995_CODE 304
#define FSM_VAR_ADD 305
#define FSM_VAR_IS_OUTPUT_STATE 306
#define FSM_VAR_BIND_EXPR 307
#define FSM_VAR_ADD_EXPR 308
#define FSM_VAR_BIND_STMT 309
#define FSM_VAR_BIND_ADD 310
#define FSM_VAR_STMT_ADD 311
#define FSM_VAR_BIND 312
#define FSM_VAR_DEALLOC 313
#define FSM_VAR_REMOVE 314
#define FSM_VAR_CLEANUP 315
#define CHECK_OPTION_VALUE 316
#define IS_VARIABLE 317
#define IS_FUNC_UNIT 318
#define IS_LEGAL_FILENAME 319
#define GET_BASENAME 320
#define GET_DIRNAME 321
#define GET_ABSOLUTE_PATH 322
#define GET_RELATIVE_PATH 323
#define DIRECTORY_EXISTS 324
#define DIRECTORY_LOAD 325
#define FILE_EXISTS 326
#define UTIL_READLINE 327
#define GET_QUOTED_STRING 328
#define SUBSTITUTE_ENV_VARS 329
#define SCOPE_EXTRACT_FRONT 330
#define SCOPE_EXTRACT_BACK 331
#define SCOPE_EXTRACT_SCOPE 332
#define SCOPE_GEN_PRINTABLE 333
#define SCOPE_COMPARE 334
#define SCOPE_LOCAL 335
#define CONVERT_FILE_TO_MODULE 336
#define GET_NEXT_VFILE 337
#define GEN_SPACE 338
#define REMOVE_UNDERSCORES 339
#define GET_FUNIT_TYPE 340
#define CALC_MISS_PERCENT 341
#define READ_COMMAND_FILE 342
#define ATTRIBUTE_CREATE 343
#define ATTRIBUTE_PARSE 344
#define ATTRIBUTE_DEALLOC 345
#define STATIC_EXPR_GEN_UNARY 346
#define STATIC_EXPR_GEN 347
#define STATIC_EXPR_CALC_LSB_AND_WIDTH_PRE 348
#define STATIC_EXPR_CALC_LSB_AND_WIDTH_POST 349
#define STATIC_EXPR_DEALLOC 350
#define VECTOR_INIT 351
#define VECTOR_INT_R64 352
#define VECTOR_INT_R32 353
#define VECTOR_CREATE 354
#define VECTOR_COPY 355
#define VECTOR_COPY_RANGE 356
#define VECTOR_CLONE 357
#define VECTOR_DB_WRITE 358
#define VECTOR_DB_READ 359
#define VECTOR_DB_MERGE 360
#define VECTOR_MERGE 361
#define VECTOR_GET_EVAL_A 362
#define VECTOR_GET_EVAL_B 363
#define VECTOR_GET_EVAL_C 364
#define VECTOR_GET_EVAL_D 365
#define VECTOR_GET_EVAL_AB_COUNT 366
#define VECTOR_GET_EVAL_ABC_COUNT 367
#define VECTOR_GET_EVAL_ABCD_COUNT 368
#define VECTOR_GET_TOGGLE01_ULONG 369
#define VECTOR_GET_TOGGLE10_ULONG 370
#define VECTOR_DISPLAY_TOGGLE01_ULONG 371
#define VECTOR_DISPLAY_TOGGLE10_ULONG 372
#define VECTOR_TOGGLE_COUNT 373
#define VECTOR_MEM_RW_COUNT 374
#define VECTOR_SET_ASSIGNED 375
#define VECTOR_SET_COVERAGE_AND_ASSIGN 376
#define VECTOR_GET_SIGN_EXTEND_VECTOR_ULONG 377
#define VECTOR_SIGN_EXTEND_ULONG 378
#define VECTOR_LSHIFT_ULONG 379
#define VECTOR_RSHIFT_ULONG 380
#define VECTOR_SET_VALUE 381
#define VECTOR_PART_SELECT_PULL 382
#define VECTOR_PART_SELECT_PUSH 383
#define VECTOR_SET_UNARY_EVALS 384
#define VECTOR_SET_AND_COMB_EVALS 385
#define VECTOR_SET_OR_COMB_EVALS 386
#define VECTOR_SET_OTHER_COMB_EVALS 387
#define VECTOR_IS_UKNOWN 388
#define VECTOR_IS_NOT_ZERO 389
#define VECTOR_SET_TO_X 390
#define VECTOR_TO_INT 391
#define VECTOR_TO_UINT64 392
#define VECTOR_TO_REAL64 393
#define VECTOR_TO_SIM_TIME 394
#define VECTOR_FROM_INT 395
#define VECTOR_FROM_UINT64 396
#define VECTOR_FROM_REAL64 397
#define VECTOR_SET_STATIC 398
#define VECTOR_TO_STRING 399
#define VECTOR_FROM_STRING_FIXED 400
#define VECTOR_FROM_STRING 401
#define VECTOR_VCD_ASSIGN 402
#define VECTOR_BITWISE_AND_OP 403
#define VECTOR_BITWISE_NAND_OP 404
#define VECTOR_BITWISE_OR_OP 405
#define VECTOR_BITWISE_NOR_OP 406
#define VECTOR_BITWISE_XOR_OP 407
#define VECTOR_BITWISE_NXOR_OP 408
#define VECTOR_OP_LT 409
#define VECTOR_OP_LE 410
#define VECTOR_OP_GT 411
#define VECTOR_OP_GE 412
#define VECTOR_OP_EQ 413
#define VECTOR_CEQ_ULONG 414
#define VECTOR_OP_CEQ 415
#define VECTOR_OP_CXEQ 416
#define VECTOR_OP_CZEQ 417
#define VECTOR_OP_NE 418
#define VECTOR_OP_CNE 419
#define VECTOR_OP_LOR 420
#define VECTOR_OP_LAND 421
#define VECTOR_OP_LSHIFT 422
#define VECTOR_OP_RSHIFT 423
#define VECTOR_OP_ARSHIFT 424
#define VECTOR_OP_ADD 425
#define VECTOR_OP_NEGATE 426
#define VECTOR_OP_SUBTRACT 427
#define VECTOR_OP_MULTIPLY 428
#define VECTOR_OP_DIVIDE 429
#define VECTOR_OP_MODULUS 430
#define VECTOR_OP_INC 431
#define VECTOR_OP_DEC 432
#define VECTOR_UNARY_INV 433
#define VECTOR_UNARY_AND 434
#define VECTOR_UNARY_NAND 435
#define VECTOR_UNARY_OR 436
#define VECTOR_UNARY_NOR 437
#define VECTOR_UNARY_XOR 438
#define VECTOR_UNARY_NXOR 439
#define VECTOR_UNARY_NOT 440
#define VECTOR_OP_EXPAND 441
#define VECTOR_OP_LIST 442
#define VECTOR_OP_CLOG2 443
#define VECTOR_DEALLOC_VALUE 444
#define VECTOR_DEALLOC 445
#define STRUCT_UNION_LENGTH 446
#define STRUCT_UNION_ADD_MEMBER 447
#define STRUCT_UNION_ADD_MEMBER_VOID 448
#define STRUCT_UNION_ADD_MEMBER_SIG 449
#define STRUCT_UNION_ADD_MEMBER_TYPEDEF 450
#define STRUCT_UNION_ADD_MEMBER_ENUM 451
#define STRUCT_UNION_ADD_MEMBER_STRUCT_UNION 452
#define STRUCT_UNION_CREATE 453
#define STRUCT_UNION_MEMBER_DEALLOC 454
#define STRUCT_UNION_DEALLOC 455
#define STRUCT_UNION_DEALLOC_LIST 456
#define FSM_ARG_PARSE_STATE 457
#define FSM_ARG_PARSE 458
#define FSM_ARG_PARSE_VALUE 459
#define FSM_ARG_PARSE_TRANS 460
#define FSM_ARG_PARSE_ATTR 461
#define SCORE_ADD_ARGS 462
#define INFO_SET_VECTOR_ELEM_SIZE 463
#define INFO_DB_WRITE 464
#define INFO_DB_READ 465
#define ARGS_DB_READ 466
#define MESSAGE_DB_READ 467
#define MERGED_CDD_DB_READ 468
#define INFO_DEALLOC 469
#define CODEGEN_CREATE_EXPR_HELPER 470
#define CODEGEN_CREATE_EXPR 471
#define CODEGEN_GEN_EXPR 472
#define MERGE_CHECK 473
#define COMMAND_MERGE 474
#define SYMTABLE_ADD_SYM_SIG 475
#define SYMTABLE_INIT 476
#define SYMTABLE_CREATE 477
#define SYMTABLE_ADD 478
#define SYMTABLE_SET_VALUE 479
#define SYMTABLE_ASSIGN 480
#define SYMTABLE_DEALLOC 481
#define LINE_GET_STATS 482
#define LINE_COLLECT 483
#define LINE_GET_FUNIT_SUMMARY 484
#define LINE_GET_INST_SUMMARY 485
#define LINE_DISPLAY_INSTANCE_SUMMARY 486
#define LINE_INSTANCE_SUMMARY 487
#define LINE_DISPLAY_FUNIT_SUMMARY 488
#define LINE_FUNIT_SUMMARY 489
#define LINE_DISPLAY_VERBOSE 490
#define LINE_INSTANCE_VERBOSE 491
#define LINE_FUNIT_VERBOSE 492
#define LINE_REPORT 493
#define ENUMERATE_ADD_ITEM 494
#define ENUMERATE_END_LIST 495
#define ENUMERATE_RESOLVE 496
#define ENUMERATE_DEALLOC 497
#define ENUMERATE_DEALLOC_LIST 498
#define EXCLUDE_EXPR_ASSIGN_AND_RECALC 499
#define EXCLUDE_SIG_ASSIGN_AND_RECALC 500
#define EXCLUDE_ARC_ASSIGN_AND_RECALC 501
#define EXCLUDE_ADD_EXCLUDE_REASON 502
#define EXCLUDE_REMOVE_EXCLUDE_REASON 503
#define EXCLUDE_IS_LINE_EXCLUDED 504
#define EXCLUDE_SET_LINE_EXCLUDE 505
#define EXCLUDE_IS_TOGGLE_EXCLUDED 506
#define EXCLUDE_SET_TOGGLE_EXCLUDE 507
#define EXCLUDE_IS_COMB_EXCLUDED 508
#define EXCLUDE_SET_COMB_EXCLUDE 509
#define EXCLUDE_IS_FSM_EXCLUDED 510
#define EXCLUDE_SET_FSM_EXCLUDE 511
#define EXCLUDE_IS_ASSERT_EXCLUDED 512
#define EXCLUDE_SET_ASSERT_EXCLUDE 513
#define EXCLUDE_FIND_EXCLUDE_REASON 514
#define EXCLUDE_DB_WRITE 515
#define EXCLUDE_DB_READ 516
#define EXCLUDE_RESOLVE_REASON 517
#define EXCLUDE_DB_MERGE 518
#define EXCLUDE_MERGE 519
#define EXCLUDE_FIND_SIGNAL 520
#define EXCLUDE_FIND_EXPRESSION 521
#define EXCLUDE_FIND_FSM_ARC 522
#define EXCLUDE_FORMAT_REASON 523
#define EXCLUDED_GET_MESSAGE 524
#define EXCLUDE_HANDLE_EXCLUDE_REASON 525
#define EXCLUDE_PRINT_EXCLUSION 526
#define EXCLUDE_LINE_FROM_ID 527
#define EXCLUDE_TOGGLE_FROM_ID 528
#define EXCLUDE_MEMORY_FROM_ID 529
#define EXCLUDE_EXPR_FROM_ID 530
#define EXCLUDE_FSM_FROM_ID 531
#define EXCLUDE_ASSERT_FROM_ID 532
#define EXCLUDE_APPLY_EXCLUSIONS 533
#define COMMAND_EXCLUDE 534
#define ASSERTION_PARSE 535
#define ASSERTION_PARSE_ATTR 536
#define ASSERTION_GET_STATS 537
#define ASSERTION_DISPLAY_INSTANCE_SUMMARY 538
#define ASSERTION_INSTANCE_SUMMARY 539
#define ASSERTION_DISPLAY_FUNIT_SUMMARY 540
#define ASSERTION_FUNIT_SUMMARY 541
#define ASSERTION_DISPLAY_VERBOSE 542
#define ASSERTION_INSTANCE_VERBOSE 543
#define ASSERTION_FUNIT_VERBOSE 544
#define ASSERTION_REPORT 545
#define ASSERTION_GET_FUNIT_SUMMARY 546
#define ASSERTION_COLLECT 547
#define ASSERTION_GET_COVERAGE 548
#define REENTRANT_COUNT_AFU_BITS 549
#define REENTRANT_STORE_DATA_BITS 550
#define REENTRANT_RESTORE_DATA_BITS 551
#define REENTRANT_CREATE 552
#define REENTRANT_DEALLOC 553
#define TOGGLE_GET_STATS 554
#define TOGGLE_COLLECT 555
#define TOGGLE_GET_COVERAGE 556
#define TOGGLE_GET_FUNIT_SUMMARY 557
#define TOGGLE_GET_INST_SUMMARY 558
#define TOGGLE_DISPLAY_INSTANCE_SUMMARY 559
#define TOGGLE_INSTANCE_SUMMARY 560
#define TOGGLE_DISPLAY_FUNIT_SUMMARY 561
#define TOGGLE_FUNIT_SUMMARY 562
#define TOGGLE_DISPLAY_VERBOSE 563
#define TOGGLE_INSTANCE_VERBOSE 564
#define TOGGLE_FUNIT_VERBOSE 565
#define TOGGLE_REPORT 566
#define DEF_LOOKUP 567
#define IS_DEFINED 568
#define DEF_MATCH 569
#define DEF_START 570
#define DEFINE_MACRO 571
#define DO_DEFINE 572
#define DEF_IS_DONE 573
#define DEF_FINISH 574
#define DEF_UNDEFINE 575
#define INCLUDE_FILENAME 576
#define DO_INCLUDE 577
#define YYWRAP 578
#define RESET_PPLEXER 579
#define ARC_FIND_FROM_STATE 580
#define ARC_FIND_TO_STATE 581
#define ARC_FIND_ARC 582
#define ARC_FIND_ARC_BY_EXCLUSION_ID 583
#define ARC_CREATE 584
#define ARC_ADD 585
#define ARC_STATE_HITS 586
#define ARC_TRANSITION_HITS 587
#define ARC_TRANSITION_EXCLUDED 588
#define ARC_GET_STATS 589
#define ARC_DB_WRITE 590
#define ARC_DB_READ 591
#define ARC_DB_MERGE 592
#define ARC_MERGE 593
#define ARC_GET_STATES 594
#define ARC_GET_TRANSITIONS 595
#define ARC_ARE_ANY_EXCLUDED 596
#define ARC_DEALLOC 597
#define LEXER_KEYWORD_2001_CODE 598
#define LEXER_KEYWORD_1995_CODE 599
#define VSIGNAL_INIT 600
#define VSIGNAL_CREATE 601
#define VSIGNAL_CREATE_VEC 602
#define VSIGNAL_DUPLICATE 603
#define VSIGNAL_DB_WRITE 604
#define VSIGNAL_DB_READ 605
#define VSIGNAL_DB_MERGE 606
#define VSIGNAL_MERGE 607
#define VSIGNAL_PROPAGATE 608
#define VSIGNAL_VCD_ASSIGN 609
#define VSIGNAL_ADD_EXPRESSION 610
#define VSIGNAL_FROM_STRING 611
#define VSIGNAL_CALC_WIDTH_FOR_EXPR 612
#define VSIGNAL_CALC_LSB_FOR_EXPR 613
#define VSIGNAL_DEALLOC 614
#define LEXER_KEYWORD_SV_CODE 615
#define PARSER_PORT_DECLARATION_A 616
#define PARSER_PORT_DECLARATION_B 617
#define PARSER_PORT_DECLARATION_C 618
#define PARSER_STATIC_EXPR_PRIMARY_A 619
#define PARSER_STATIC_EXPR_PRIMARY_B 620
#define PARSER_EXPRESSION_LIST_A 621
#define PARSER_EXPRESSION_LIST_B 622
#define PARSER_EXPRESSION_LIST_C 623
#define PARSER_EXPRESSION_LIST_D 624
#define PARSER_IDENTIFIER_A 625
#define PARSER_GENERATE_CASE_ITEM_A 626
#define PARSER_GENERATE_CASE_ITEM_B 627
#define PARSER_GENERATE_CASE_ITEM_C 628
#define PARSER_STATEMENT_BEGIN_A 629
#define PARSER_STATEMENT_FORK_A 630
#define PARSER_STATEMENT_FOR_A 631
#define PARSER_CASE_ITEM_A 632
#define PARSER_CASE_ITEM_B 633
#define PARSER_CASE_ITEM_C 634
#define PARSER_DELAY_VALUE_A 635
#define PARSER_DELAY_VALUE_B 636
#define PARSER_PARAMETER_VALUE_BYNAME_A 637
#define PARSER_GATE_INSTANCE_A 638
#define PARSER_GATE_INSTANCE_B 639
#define PARSER_GATE_INSTANCE_C 640
#define PARSER_GATE_INSTANCE_D 641
#define PARSER_LIST_OF_NAMES_A 642
#define PARSER_LIST_OF_NAMES_B 643
#define MEMORY_GET_STAT 644
#define MEMORY_GET_STATS 645
#define MEMORY_GET_FUNIT_SUMMARY 646
#define MEMORY_GET_INST_SUMMARY 647
#define MEMORY_CREATE_PDIM_BIT_ARRAY 648
#define MEMORY_GET_MEM_COVERAGE 649
#define MEMORY_GET_COVERAGE 650
#define MEMORY_COLLECT 651
#define MEMORY_DISPLAY_TOGGLE_INSTANCE_SUMMARY 652
#define MEMORY_TOGGLE_INSTANCE_SUMMARY 653
#define MEMORY_DISPLAY_AE_INSTANCE_SUMMARY 654
#define MEMORY_AE_INSTANCE_SUMMARY 655
#define MEMORY_DISPLAY_TOGGLE_FUNIT_SUMMARY 656
#define MEMORY_TOGGLE_FUNIT_SUMMARY 657
#define MEMORY_DISPLAY_AE_FUNIT_SUMMARY 658
#define MEMORY_AE_FUNIT_SUMMARY 659
#define MEMORY_DISPLAY_MEMORY 660
#define MEMORY_DISPLAY_VERBOSE 661
#define MEMORY_INSTANCE_VERBOSE 662
#define MEMORY_FUNIT_VERBOSE 663
#define MEMORY_REPORT 664
#define EXPRESSION_CREATE_TMP_VECS 665
#define EXPRESSION_CREATE_NBA 666
#define EXPRESSION_IS_NBA_LHS 667
#define EXPRESSION_CREATE_VALUE 668
#define EXPRESSION_CREATE 669
#define EXPRESSION_SET_VALUE 670
#define EXPRESSION_SET_SIGNED 671
#define EXPRESSION_RESIZE 672
#define EXPRESSION_GET_ID 673
#define EXPRESSION_GET_FIRST_LINE_EXPR 674
#define EXPRESSION_GET_LAST_LINE_EXPR 675
#define EXPRESSION_GET_CURR_DIMENSION 676
#define EXPRESSION_FIND_RHS_SIGS 677
#define EXPRESSION_FIND_PARAMS 678
#define EXPRESSION_FIND_ULINE_ID 679
#define EXPRESSION_FIND_EXPR 680
#define EXPRESSION_CONTAINS_EXPR_CALLING_STMT 681
#define EXPRESSION_GET_ROOT_STATEMENT 682
#define EXPRESSION_ASSIGN_EXPR_IDS 683
#define EXPRESSION_DB_WRITE 684
#define EXPRESSION_DB_WRITE_TREE 685
#define EXPRESSION_DB_READ 686
#define EXPRESSION_DB_MERGE 687
#define EXPRESSION_MERGE 688
#define EXPRESSION_STRING_OP 689
#define EXPRESSION_STRING 690
#define EXPRESSION_OP_FUNC__XOR 691
#define EXPRESSION_OP_FUNC__XOR_A 692
#define EXPRESSION_OP_FUNC__MULTIPLY 693
#define EXPRESSION_OP_FUNC__MULTIPLY_A 694
#define EXPRESSION_OP_FUNC__DIVIDE 695
#define EXPRESSION_OP_FUNC__DIVIDE_A 696
#define EXPRESSION_OP_FUNC__MOD 697
#define EXPRESSION_OP_FUNC__MOD_A 698
#define EXPRESSION_OP_FUNC__ADD 699
#define EXPRESSION_OP_FUNC__ADD_A 700
#define EXPRESSION_OP_FUNC__SUBTRACT 701
#define EXPRESSION_OP_FUNC__SUB_A 702
#define EXPRESSION_OP_FUNC__AND 703
#define EXPRESSION_OP_FUNC__AND_A 704
#define EXPRESSION_OP_FUNC__OR 705
#define EXPRESSION_OP_FUNC__OR_A 706
#define EXPRESSION_OP_FUNC__NAND 707
#define EXPRESSION_OP_FUNC__NOR 708
#define EXPRESSION_OP_FUNC__NXOR 709
#define EXPRESSION_OP_FUNC__LT 710
#define EXPRESSION_OP_FUNC__GT 711
#define EXPRESSION_OP_FUNC__LSHIFT 712
#define EXPRESSION_OP_FUNC__LSHIFT_A 713
#define EXPRESSION_OP_FUNC__RSHIFT 714
#define EXPRESSION_OP_FUNC__RSHIFT_A 715
#define EXPRESSION_OP_FUNC__ARSHIFT 716
#define EXPRESSION_OP_FUNC__ARSHIFT_A 717
#define EXPRESSION_OP_FUNC__TIME 718
#define EXPRESSION_OP_FUNC__RANDOM 719
#define EXPRESSION_OP_FUNC__SASSIGN 720
#define EXPRESSION_OP_FUNC__SRANDOM 721
#define EXPRESSION_OP_FUNC__URANDOM 722
#define EXPRESSION_OP_FUNC__URANDOM_RANGE 723
#define EXPRESSION_OP_FUNC__REALTOBITS 724
#define EXPRESSION_OP_FUNC__BITSTOREAL 725
#define EXPRESSION_OP_FUNC__SHORTREALTOBITS 726
#define EXPRESSION_OP_FUNC__BITSTOSHORTREAL 727
#define EXPRESSION_OP_FUNC__ITOR 728
#define EXPRESSION_OP_FUNC__RTOI 729
#define EXPRESSION_OP_FUNC__TEST_PLUSARGS 730
#define EXPRESSION_OP_FUNC__VALUE_PLUSARGS 731
#define EXPRESSION_OP_FUNC__SIGNED 732
#define EXPRESSION_OP_FUNC__UNSIGNED 733
#define EXPRESSION_OP_FUNC__CLOG2 734
#define EXPRESSION_OP_FUNC__EQ 735
#define EXPRESSION_OP_FUNC__CEQ 736
#define EXPRESSION_OP_FUNC__LE 737
#define EXPRESSION_OP_FUNC__GE 738
#define EXPRESSION_OP_FUNC__NE 739
#define EXPRESSION_OP_FUNC__CNE 740
#define EXPRESSION_OP_FUNC__LOR 741
#define EXPRESSION_OP_FUNC__LAND 742
#define EXPRESSION_OP_FUNC__COND 743
#define EXPRESSION_OP_FUNC__COND_SEL 744
#define EXPRESSION_OP_FUNC__UINV 745
#define EXPRESSION_OP_FUNC__UAND 746
#define EXPRESSION_OP_FUNC__UNOT 747
#define EXPRESSION_OP_FUNC__UOR 748
#define EXPRESSION_OP_FUNC__UXOR 749
#define EXPRESSION_OP_FUNC__UNAND 750
#define EXPRESSION_OP_FUNC__UNOR 751
#define EXPRESSION_OP_FUNC__UNXOR 752
#define EXPRESSION_OP_FUNC__NULL 753
#define EXPRESSION_OP_FUNC__SIG 754
#define EXPRESSION_OP_FUNC__SBIT 755
#define EXPRESSION_OP_FUNC__MBIT 756
#define EXPRESSION_OP_FUNC__EXPAND 757
#define EXPRESSION_OP_FUNC__LIST 758
#define EXPRESSION_OP_FUNC__CONCAT 759
#define EXPRESSION_OP_FUNC__PEDGE 760
#define EXPRESSION_OP_FUNC__NEDGE 761
#define EXPRESSION_OP_FUNC__AEDGE 762
#define EXPRESSION_OP_FUNC__EOR 763
#define EXPRESSION_OP_FUNC__SLIST 764
#define EXPRESSION_OP_FUNC__DELAY 765
#define EXPRESSION_OP_FUNC__TRIGGER 766
#define EXPRESSION_OP_FUNC__CASE 767
#define EXPRESSION_OP_FUNC__CASEX 768
#define EXPRESSION_OP_FUNC__CASEZ 769
#define EXPRESSION_OP_FUNC__DEFAULT 770
#define EXPRESSION_OP_FUNC__BASSIGN 771
#define EXPRESSION_OP_FUNC__FUNC_CALL 772
#define EXPRESSION_OP_FUNC__TASK_CALL 773
#define EXPRESSION_OP_FUNC__NB_CALL 774
#define EXPRESSION_OP_FUNC__FORK 775
#define EXPRESSION_OP_FUNC__JOIN 776
#define EXPRESSION_OP_FUNC__DISABLE 777
#define EXPRESSION_OP_FUNC__REPEAT 778
#define EXPRESSION_OP_FUNC__EXPONENT 779
#define EXPRESSION_OP_FUNC__PASSIGN 780
#define EXPRESSION_OP_FUNC__MBIT_POS 781
#define EXPRESSION_OP_FUNC__MBIT_NEG 782
#define EXPRESSION_OP_FUNC__NEGATE 783
#define EXPRESSION_OP_FUNC__IINC 784
#define EXPRESSION_OP_FUNC__PINC 785
#define EXPRESSION_OP_FUNC__IDEC 786
#define EXPRESSION_OP_FUNC__PDEC 787
#define EXPRESSION_OP_FUNC__DLY_ASSIGN 788
#define EXPRESSION_OP_FUNC__DLY_OP 789
#define EXPRESSION_OP_FUNC__REPEAT_DLY 790
#define EXPRESSION_OP_FUNC__DIM 791
#define EXPRESSION_OP_FUNC__WAIT 792
#define EXPRESSION_OP_FUNC__FINISH 793
#define EXPRESSION_OP_FUNC__STOP 794
#define EXPRESSION_OPERATE 795
#define EXPRESSION_OPERATE_RECURSIVELY 796
#define EXPRESSION_IS_STATIC_ONLY_HELPER 797
#define EXPRESSION_IS_ASSIGNED 798
#define EXPRESSION_IS_BIT_SELECT 799
#define EXPRESSION_IS_LAST_SELECT 800
#define EXPRESSION_IS_IN_RASSIGN 801
#define EXPRESSION_SET_ASSIGNED 802
#define EXPRESSION_SET_CHANGED 803
#define EXPRESSION_ASSIGN 804
#define EXPRESSION_DEALLOC 805
#define PARSE_READLINE 806
#define PARSE_DESIGN 807
#define PARSE_AND_SCORE_DUMPFILE 808
#define FUNC_ITER_DISPLAY 809
#define FUNC_ITER_SORT 810
#define FUNC_ITER_COUNT_STMT_ITERS 811
#define FUNC_ITER_ADD_STMT_LINKS 812
#define FUNC_ITER_ADD_SIG_LINKS 813
#define FUNC_ITER_INIT 814
#define FUNC_ITER_GET_NEXT_STATEMENT 815
#define FUNC_ITER_GET_NEXT_SIGNAL 816
#define FUNC_ITER_DEALLOC 817
#define DB_CREATE 818
#define DB_CLOSE 819
#define DB_CHECK_FOR_TOP_MODULE 820
#define DB_WRITE 821
#define DB_READ 822
#define DB_MERGE_INSTANCE_TREES 823
#define DB_SCALE_TO_PRECISION 824
#define DB_CREATE_UNNAMED_SCOPE 825
#define DB_IS_UNNAMED_SCOPE 826
#define DB_SET_TIMESCALE 827
#define DB_GET_CURR_FUNIT 828
#define DB_GET_EXCLUSION_ID_SIZE 829
#define DB_GEN_EXCLUSION_ID 830
#define DB_ADD_FILE_VERSION 831
#define DB_OUTPUT_DUMPVARS 832
#define DB_ADD_INSTANCE 833
#define DB_ADD_MODULE 834
#define DB_END_MODULE 835
#define DB_ADD_FUNCTION_TASK_NAMEDBLOCK 836
#define DB_END_FUNCTION_TASK_NAMEDBLOCK 837
#define DB_ADD_DECLARED_PARAM 838
#define DB_ADD_OVERRIDE_PARAM 839
#define DB_ADD_VECTOR_PARAM 840
#define DB_ADD_DEFPARAM 841
#define DB_ADD_SIGNAL 842
#define DB_ADD_ENUM 843
#define DB_END_ENUM_LIST 844
#define DB_ADD_TYPEDEF 845
#define DB_FIND_SIGNAL 846
#define DB_ADD_GEN_ITEM_BLOCK 847
#define DB_FIND_GEN_ITEM 848
#define DB_FIND_TYPEDEF 849
#define DB_GET_CURR_GEN_BLOCK 850
#define DB_CURR_SIGNAL_COUNT 851
#define DB_CREATE_EXPRESSION 852
#define DB_BIND_EXPR_TREE 853
#define DB_CREATE_EXPR_FROM_STATIC 854
#define DB_ADD_EXPRESSION 855
#define DB_CREATE_SENSITIVITY_LIST 856
#define DB_PARALLELIZE_STATEMENT 857
#define DB_CREATE_STATEMENT 858
#define DB_ADD_STATEMENT 859
#define DB_REMOVE_STATEMENT_FROM_CURRENT_FUNIT 860
#define DB_REMOVE_STATEMENT 861
#define DB_CONNECT_STATEMENT_TRUE 862
#define DB_CONNECT_STATEMENT_FALSE 863
#define DB_GEN_ITEM_CONNECT_TRUE 864
#define DB_GEN_ITEM_CONNECT_FALSE 865
#define DB_GEN_ITEM_CONNECT 866
#define DB_STATEMENT_CONNECT 867
#define DB_CREATE_ATTR_PARAM 868
#define DB_PARSE_ATTRIBUTE 869
#define DB_REMOVE_STMT_BLKS_CALLING_STATEMENT 870
#define DB_GEN_CURR_INST_SCOPE 871
#define DB_SYNC_CURR_INSTANCE 872
#define DB_SET_VCD_SCOPE 873
#define DB_VCD_UPSCOPE 874
#define DB_ASSIGN_SYMBOL 875
#define DB_SET_SYMBOL_CHAR 876
#define DB_SET_SYMBOL_STRING 877
#define DB_DO_TIMESTEP 878
#define DB_CHECK_DUMPFILE_SCOPES 879
#define VLERROR 880
#define VLWARN 881
#define PARSER_DEALLOC_SIG_RANGE 882
#define PARSER_COPY_CURR_RANGE 883
#define PARSER_COPY_RANGE_TO_CURR_RANGE 884
#define PARSER_EXPLICITLY_SET_CURR_RANGE 885
#define PARSER_IMPLICITLY_SET_CURR_RANGE 886
#define PARSER_CHECK_GENERATION 887
#define PARSER_HANDLE_CASE_STATEMENT 888
#define PARSER_HANDLE_CASE_STATEMENT_LIST 889
#define PARSER_HANDLE_GENERATE_CASE_STATEMENT 890
#define PARSER_HANDLE_GENERATE_CASE_STATEMENT_LIST 891
#define MOD_PARM_FIND 892
#define MOD_PARM_FIND_EXPR_AND_REMOVE 893
#define MOD_PARM_ADD 894
#define INST_PARM_FIND 895
#define INST_PARM_ADD 896
#define INST_PARM_ADD_GENVAR 897
#define INST_PARM_BIND 898
#define DEFPARAM_ADD 899
#define DEFPARAM_DEALLOC 900
#define PARAM_FIND_AND_SET_EXPR_VALUE 901
#define PARAM_SET_SIG_SIZE 902
#define PARAM_SIZE_FUNCTION 903
#define PARAM_EXPR_EVAL 904
#define PARAM_HAS_OVERRIDE 905
#define PARAM_HAS_DEFPARAM 906
#define PARAM_RESOLVE_DECLARED 907
#define PARAM_RESOLVE_OVERRIDE 908
#define PARAM_RESOLVE_INST 909
#define PARAM_RESOLVE 910
#define PARAM_DB_WRITE 911
#define MOD_PARM_DEALLOC 912
#define INST_PARM_DEALLOC 913
#define STR_LINK_ADD 914
#define STMT_LINK_ADD_HEAD 915
#define EXP_LINK_ADD 916
#define SIG_LINK_ADD 917
#define FSM_LINK_ADD 918
#define FUNIT_LINK_ADD 919
#define GITEM_LINK_ADD 920
#define INST_LINK_ADD 921
#define STR_LINK_FIND 922
#define STMT_LINK_FIND 923
#define STMT_LINK_FIND_BY_POS 924
#define EXP_LINK_FIND 925
#define EXP_LINK_FIND_BY_POS 926
#define SIG_LINK_FIND 927
#define FSM_LINK_FIND 928
#define FSM_LINK_FIND_BY_POS 929
#define FUNIT_LINK_FIND 930
#define GITEM_LINK_FIND 931
#define INST_LINK_FIND_BY_SCOPE 932
#define INST_LINK_FIND_BY_FUNIT 933
#define STR_LINK_REMOVE 934
#define EXP_LINK_REMOVE 935
#define GITEM_LINK_REMOVE 936
#define FUNIT_LINK_REMOVE 937
#define STR_LINK_DELETE_LIST 938
#define STMT_LINK_UNLINK 939
#define STMT_LINK_DELETE_LIST 940
#define EXP_LINK_DELETE_LIST 941
#define SIG_LINK_DELETE_LIST 942
#define FSM_LINK_DELETE_LIST 943
#define FUNIT_LINK_DELETE_LIST 944
#define GITEM_LINK_DELETE_LIST 945
#define INST_LINK_DELETE_LIST 946
#define FUNIT_INIT 947
#define FUNIT_CREATE 948
#define FUNIT_GET_CURR_MODULE 949
#define FUNIT_GET_CURR_MODULE_SAFE 950
#define FUNIT_GET_CURR_FUNCTION 951
#define FUNIT_GET_CURR_TASK 952
#define FUNIT_GET_PORT_COUNT 953
#define FUNIT_FIND_PARAM 954
#define FUNIT_FIND_SIGNAL 955
#define FUNIT_REMOVE_STMT_BLKS_CALLING_STMT 956
#define FUNIT_GEN_TASK_FUNCTION_NAMEDBLOCK_NAME 957
#define FUNIT_SIZE_ELEMENTS 958
#define FUNIT_DB_WRITE 959
#define FUNIT_DB_READ 960
#define FUNIT_VERSION_DB_READ 961
#define FUNIT_DB_INST_MERGE 962
#define FUNIT_DB_MOD_MERGE 963
#define FUNIT_MERGE 964
#define FUNIT_FLATTEN_NAME 965
#define FUNIT_FIND_BY_ID 966
#define FUNIT_IS_TOP_MODULE 967
#define FUNIT_IS_UNNAMED 968
#define FUNIT_IS_UNNAMED_CHILD_OF 969
#define FUNIT_IS_CHILD_OF 970
#define FUNIT_DISPLAY_SIGNALS 971
#define FUNIT_DISPLAY_EXPRESSIONS 972
#define STATEMENT_ADD_THREAD 973
#define FUNIT_PUSH_THREADS 974
#define STATEMENT_DELETE_THREAD 975
#define FUNIT_OUTPUT_DUMPVARS 976
#define FUNIT_IS_ONE_SIGNAL_ASSIGNED 977
#define FUNIT_CLEAN 978
#define FUNIT_DEALLOC 979
#define SYM_VALUE_STORE 980
#define ADD_SYM_VALUES_TO_SIM 981
#define COVERED_VALUE_CHANGE_BIN 982
#define COVERED_VALUE_CHANGE_REAL 983
#define COVERED_END_OF_SIM 984
#define COVERED_CB_ERROR_HANDLER 985
#define GEN_NEXT_SYMBOL 986
#define COVERED_CREATE_VALUE_CHANGE_CB 987
#define COVERED_PARSE_TASK_FUNC 988
#define COVERED_PARSE_SIGNALS 989
#define COVERED_PARSE_INSTANCE 990
#define COVERED_SIM_CALLTF 991
#define OBFUSCATE_SET_MODE 992
#define OBFUSCATE_NAME 993
#define OBFUSCATE_DEALLOC 994
#define STATISTIC_CREATE 995
#define STATISTIC_IS_EMPTY 996
#define STATISTIC_DEALLOC 997
#define BIND_ADD 998
#define BIND_APPEND_FSM_EXPR 999
#define BIND_REMOVE 1000
#define BIND_FIND_SIG_NAME 1001
#define BIND_PARAM 1002
#define BIND_SIGNAL 1003
#define BIND_TASK_FUNCTION_PORTS 1004
#define BIND_TASK_FUNCTION_NAMEDBLOCK 1005
#define BIND_PERFORM 1006
#define BIND_DEALLOC 1007
#define LEXER_CSTRING_A 1008
#define LEXER_KEYWORD_A 1009
#define LEXER_ESCAPED_NAME 1010
#define LEXER_SYSTEM_CALL 1011
#define LINE_DIRECTIVE 1012
#define LINE_DIRECTIVE2 1013
#define PROCESS_TIMESCALE_TOKEN 1014
#define PROCESS_TIMESCALE 1015
#define LEXER_YYWRAP 1016
#define RESET_LEXER 1017
#define CHECK_FOR_PRAGMA 1018
#define LEXER_KEYWORD_SYS_2001_CODE 1019
#define STMT_BLK_ADD_TO_REMOVE_LIST 1020
#define STMT_BLK_REMOVE 1021
#define STMT_BLK_SPECIFY_REMOVAL_REASON 1022
#define SCOPE_FIND_FUNIT_FROM_SCOPE 1023
#define SCOPE_FIND_PARAM 1024
#define SCOPE_FIND_SIGNAL 1025
#define SCOPE_FIND_TASK_FUNCTION_NAMEDBLOCK 1026
#define SCOPE_GET_PARENT_FUNIT 1027
#define SCOPE_GET_PARENT_MODULE 1028
#define GEN_ITEM_STRINGIFY 1029
#define GEN_ITEM_DISPLAY 1030
#define GEN_ITEM_DISPLAY_BLOCK_HELPER 1031
#define GEN_ITEM_DISPLAY_BLOCK 1032
#define GEN_ITEM_COMPARE 1033
#define GEN_ITEM_FIND 1034
#define GEN_ITEM_REMOVE_IF_CONTAINS_EXPR_CALLING_STMT 1035
#define GEN_ITEM_GET_GENVAR 1036
#define GEN_ITEM_VARNAME_CONTAINS_GENVAR 1037
#define GEN_ITEM_CALC_SIGNAL_NAME 1038
#define GEN_ITEM_CREATE_EXPR 1039
#define GEN_ITEM_CREATE_SIG 1040
#define GEN_ITEM_CREATE_STMT 1041
#define GEN_ITEM_CREATE_INST 1042
#define GEN_ITEM_CREATE_TFN 1043
#define GEN_ITEM_CREATE_BIND 1044
#define GEN_ITEM_RESIZE_STMTS_AND_SIGS 1045
#define GEN_ITEM_ASSIGN_IDS 1046
#define GEN_ITEM_DB_WRITE 1047
#define GEN_ITEM_DB_WRITE_EXPR_TREE 1048
#define GEN_ITEM_CONNECT 1049
#define GEN_ITEM_RESOLVE 1050
#define GEN_ITEM_BIND 1051
#define GENERATE_RESOLVE_INST 1052
#define GENERATE_REMOVE_STMT_HELPER 1053
#define GENERATE_REMOVE_STMT 1054
#define GEN_ITEM_DEALLOC 1055
#define TREE_ADD 1056
#define TREE_FIND 1057
#define TREE_REMOVE 1058
#define TREE_DEALLOC 1059

extern profiler profiles[NUM_PROFILES];
#endif

extern unsigned int profile_index;

#endif

