/*
** Copyright 2000-2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"cmlmsubunsubmsg.h"
#include	"afx/afx.h"
#include	"random128/random128.h"
#include	"dbobj.h"
#include	"mydirent.h"
#include	<iostream>
#include	<fstream>
#include	<ctype.h>
#include	<time.h>
#include	<sysexits.h>

static const char rcsid[]="$Id: cmlmsubunsubmsg.C,v 1.7 2005/04/05 15:42:18 mrsam Exp $";
//
//  Initial subscription/unsubscription request.
//

static int dosubunsub(CString, CString,
	const char *, const char *, const char *, int, const char *);

int dosub(const char *address)
{
CString	postoptions= cmdget("SUBSCRIBE");
CString	msg(readmsg());
CString addr=returnaddr(msg, address);

	if (postoptions == "mod")
		return (dosubunsub(msg, addr, "sub", "modsubconfirm",
			"sub4.tmpl", 1, 0));

	return (dosubunsub(msg, addr, "sub", "subconfirm", "sub.tmpl", 0, 0));
}

int dounsub(const char *address)
{
CString	msg(readmsg());
CString addr=returnaddr(msg, address);

	return (dosubunsub(msg, addr, "unsub", "unsubconfirm", "unsub.tmpl",
		0, 0));
}

// Set a write-only alias.

int doalias(const char *address)
{
CString	msg(readmsg());
CString addr=returnaddr(msg, address);

	return (dosubunsub(msg, addr, "alias", "aliasconfirm", "sub.tmpl", 0,
		"X-Alias: " + header(msg, "subject")));
}

// Moderated subscription approval

int domodsub(const char *address)
{
CString	msg(readmsg());

CString addr="";
CString filename=address;
char    *p=filename.GetBuffer(-1);

	while (*p)
	{
		*p=toupper((int)(unsigned char)*p);
		if (*p < 'A' || *p > 'Z')       break;
		++p;
	}

        if (*p == 0)
        {
                filename.ReleaseBuffer(-1);
                filename=COMMANDS "/sub." + filename;

        ifstream        ifs(filename);

                if ( addr << ifs )
                        addr="";
        }
	else
		filename.ReleaseBuffer(-1);

	if (addr == "")
	{
		cerr << "Invalid address." << endl;
		return (EX_SOFTWARE);
	}

CString token;
CString	subj;

{
CommandLock	cmd_lock;

DbObj	dat;

	if (dat.Open(COMMANDSDAT, "C"))
	{
		perror(COMMANDSDAT);
		return (EX_OSERR);
	}

ifstream	ifs;

char	*filename;
size_t	filename_l;
CString	key="sub." + addr;
CString	subfilename;

	addrlower(key.GetBuffer(-1)); 

	filename=dat.Fetch(key, key.GetLength(), filename_l, "");

	if (filename)
	{
	CString	buf;

		memcpy(buf.GetBuffer(filename_l), filename, filename_l);
		buf.ReleaseBuffer(filename_l);

		subfilename= COMMANDS "/" + buf;
		free(filename);

		ifs.open(subfilename);
	}

	if (subfilename.GetLength() <= 0 ||
		(token << ifs) || goodconfirm(msg))
	{
		cerr << "Invalid confirmation." << endl;
		return (EX_SOFTWARE);
	}

	while ((token << ifs) == 0)
		if (token.GetLength() == 0)	break;

	while ((token << ifs) == 0)
		if (token == MSGSEPARATOR)	break;

	subj=header(msg, "subject");		// Original subject

// Rebuild original msg.

	msg="";
	while ((token << ifs) == 0)
	{
		if (token.GetLength() == 0)	continue;
		msg += token;
		msg += '\n';
	}

	ifs.close();
	unlink(subfilename);
	dat.Delete(key, key.GetLength());
}

	subj.TrimLeft();
	if (subj.Left(2) == "no")
	{
	CString owner=get_verp_return("owner", 0);
	pid_t	p;
	afxopipestream ack(sendmail_bcc(p, owner));

		ack << "From: " << myname() << " <" << owner << ">" << endl
			<< "To: " << addr << endl
			<< "Bcc: " << addr << endl;

		ack_template(ack, "sub5.tmpl", msg);
		ack.close();
		return (wait4sendmail(p));
	}

	return (dosubunsub(msg, addr, "sub", "subconfirm", "sub.tmpl", 0, 0));
}

static int dosubunsub(CString msg,	// Message headers, for logging
		CString	addr,		// Parsed address
		const char *cmdpfix,	// Prefix for the commands/ file
		const char *retpfix,	// Prefix on the return address
		const char *tpl,	// Template for the acknowledgement
		int flag,		// Non-true if moderator sub approval
		const char * xh)	// Extra header on response, for aliases
{
fstream	tokfile;

	if (addr == "")
	{
		cerr << "Invalid address." << endl;
		return (EX_SOFTWARE);
	}

CommandLock	cmd_lock;

DbObj	dat;

	if (dat.Open(COMMANDSDAT, "C"))
	{
		perror(COMMANDSDAT);
		return (EX_OSERR);
	}

CString	key(cmdpfix);

	key += '.';
	key += addr;

	addrlower(key.GetBuffer(-1));

CString	subfilename;

struct	stat stat_buf;
char *	filename;
size_t	filename_l;

	filename=dat.Fetch(key, key.GetLength(), filename_l, "");

	if (filename)
	{
	CString	buf;

		memcpy(buf.GetBuffer(filename_l), filename, filename_l);
		buf.ReleaseBuffer(filename_l);

		subfilename= COMMANDS "/" + buf;
		free(filename);
	}
	else
	{
	CString	f;

		do
		{
			f=cmdpfix;
			f += '.';
			f += random128_alpha();

			subfilename = COMMANDS "/" + f;

		} while (stat(subfilename, &stat_buf) == 0);

		if (dat.Store(key, key.GetLength(),
			f, f.GetLength(), "R"))
		{
			perror(COMMANDSDAT);
			return (EX_OSERR);
		}
	}

time_t	curtime;

	time(&curtime);

//
//  At most, acknowledge a subscription for the same addresses no
//  more frequently then once per 30 minutes -- this stops a subscription bomb.
//
	if (stat(subfilename, &stat_buf) == 0
		&& stat_buf.st_mtime >= curtime - 30 * 60)
		return (0);

//
//  Into the token file we write: address, newline, token, newline, then the
//  confirmation request.
//

	tokfile.open(subfilename, ios::in | ios::out | ios::trunc);

	if (!tokfile.is_open())
	{
		perror("open");
		return (1);
	}

CString me=retpfix;

	me += "-";
	me += strrchr(subfilename, '.')+1;

	me=get_verp_return(me, 0);

CString owner=get_verp_return("owner", 0);

CString	sendto=addr;


	if (flag)
		sendto=owner;

	tokfile << addr << endl;

	if (xh)
		tokfile << xh << endl;

	tokfile << "From: " << myname() << " <" << owner << ">" << endl
		<< "Reply-To: " << me << endl
		<< "To: " << sendto << endl;

	{
		ifstream ifs("confsubj.tmpl");

		if (!ifs.bad())
		{
			CString s;

			if ( (s << ifs) == 0)
			{
				tokfile << s << endl;
			}
		}
	}

	ack_template(tokfile, tpl, msg);

CString	buf;

	tokfile.seekg(0);
	if (tokfile.bad())
	{
		perror("write");
		tokfile.close();
		unlink(subfilename);
		return (EX_OSERR);
	}

pid_t	p;
afxopipestream	ack(sendmail_bcc(p, owner));

	ack << "Bcc: " << sendto << endl;

	buf << tokfile;		// Skip token number

	while ( (buf << tokfile) == 0)
		ack << buf << endl;

	tokfile.close();
	ack.close();
	return (wait4sendmail(p));
}

//
//  Subscription confirmation.
//

int dosubunsubconfirm(const char *address, const char *pfix,
		int (*func)(const char *, CString),
		const char *good_template,
		const char *bad_template,
		int donotsend)
{
CString	msg(readmsg());
CString addr="";

CString	filename=address;
char	*p=filename.GetBuffer(-1);

	while (*p)
	{
		*p=toupper((int)(unsigned char)*p);
		if (*p < 'A' || *p > 'Z')	break;
		++p;
	}

	if (*p == 0)
	{
		filename.ReleaseBuffer(-1);
		filename=COMMANDS "/" + (pfix + ("." + filename));

	ifstream	ifs(filename);

		if ( addr << ifs )
			addr="";
	}
	else
		filename.ReleaseBuffer(-1);

	if (addr != "")
	{
	CommandLock	cmd_lock;

	DbObj	dat;

		if (dat.Open(COMMANDSDAT, "C"))
		{
			perror(COMMANDSDAT);
			return (EX_OSERR);
		}

	ifstream	ifs;

	char	*filename;
	size_t	filename_l;
	CString	key=pfix;

		key += '.';
		key += addr;

	CString	subfilename;

		addrlower(key.GetBuffer(-1));

		filename=dat.Fetch(key, key.GetLength(), filename_l, "");

		if (filename)
		{
		CString	buf;

			memcpy(buf.GetBuffer(filename_l), filename, filename_l);
			buf.ReleaseBuffer(filename_l);

			subfilename= COMMANDS "/" + buf;
			free(filename);

			ifs.open(subfilename);
		}


	CString token;

		if (subfilename.GetLength() &&
			(token << ifs) == 0 && goodconfirm(msg) == 0)
		{
//
//  We will save the original subscription request, and the acknowledgement,
//  in this luser's subscribtion record.
//
		CString	subbuf;

			subbuf="";
			while ((token << ifs) == 0)
			{
				subbuf += token;
				subbuf += '\n';
			}
			subbuf += "\n*** ACKNOWLEDGEMENT ***\n";
			subbuf += msg;
			ifs.close();

		int	rc=(*func)(addr, subbuf);

			if (rc == 0)
				donotsend=0;

			if (rc == 0 || rc == 9)
			{
				unlink(subfilename);
				dat.Delete(key, key.GetLength());

				if (!donotsend)
				{
				pid_t	p;
				CString	owner=get_verp_return("owner", 0);
				afxopipestream ack(sendmail_bcc(p, owner));
				
					owner= myname() + (" <" + owner + ">");

					ack << "Bcc: " << addr << endl
						<< "From: " << owner << endl
						<< "Reply-To: " << owner
								<< endl
						<< "To: "
							<< (const char *)addr
							<< endl;

					ack_template(ack,
							rc ? bad_template:
							good_template, msg);
					ack.close();
					rc=wait4sendmail(p);
				}

			}
			dat.Close();

		DIR	*dirp;
		struct	dirent	*de=0;

			if ((dirp=opendir(COMMANDS)) != 0)
			{
				while ((de=readdir(dirp)) != 0)
					if ((de->d_name[0]) != '.')
						break;
				closedir(dirp);
			}

			if (de == 0)	// Commands subdir is empty
				unlink(COMMANDSDAT);
			return (rc);
		}
	}
	cerr << "Invalid confirmation.\n" << endl;
	return (EX_NOPERM);
}
