#
# Courier::Filter::Logger::USM class
#
# (C) 2004-2008 Julian Mehnle <julian@mehnle.net>
# $Id: USM.pm 210 2008-03-21 19:30:31Z julian $
#
###############################################################################

package Courier::Filter::Logger::USM;

use warnings;
use strict;

use base 'Courier::Filter::Logger';

use Error ':try';

use Courier::Error;

use USM::Mail::Address;
use USM::Mail::Message::Rejected;

use constant TRUE   => (0 == 0);
use constant FALSE  => not TRUE;

# Implementation:
###############################################################################

sub log_error {
    my ($self, $text) = @_;
    chomp($text);
    STDERR->print($text, "\n");
    return;
}

sub log_rejected_message {
    my ($self, $message, $reason) = @_;
    
    #STDERR->print("DEBUG: USM logger: rejecting message because $reason\n");
    
    # Log rejection for every recipient:
    foreach my $recipient ($message->recipients) {
        my $address = USM::Mail::Address->get_by_literal($recipient);
        next if not $address;
            # Unknown (probably foreign) recipient address, don't log rejection.

        my $user = $address->user;
        next if not $user;
            # Unknown USM user, don't log rejection. This should not happen!
        
        try {
            my $rejection = USM::Mail::Message::Rejected->new();
            $rejection->user($user);
            $rejection->delivering_host($message->remote_host);
            $rejection->from_address($message->sender);
            $rejection->to_address($recipient);
            $rejection->subject($message->subject);
            $rejection->reason($reason);
            $rejection->commit();
        }
        otherwise {
            my ($error) = @_;
            $self->log_error("An error occurred while logging rejected message: $error");
        };
    }
    
    #STDERR->print("DEBUG: USM logger: finished.\n");
    
    return;
}

TRUE;
