/* tolua: get & push functions.
** Support code for Lua bindings.
** Written by Waldemar Celes
** TeCGraf/PUC-Rio
** Jul 1998
** $Id: tolua_gp.c,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
*/

/* This code is free software; you can redistribute it and/or modify it. 
** The software provided hereunder is on an "as is" basis, and 
** the author has no obligation to provide maintenance, support, updates,
** enhancements, or modifications. 
*/

#include "tolua.h"
#include "tolua_tm.h"

#include <string.h>

double tolua_getnumber (int narg, double def)
{
 lua_Object lo = lua_getparam(narg);
 return lo==LUA_NOOBJECT ? def : lua_getnumber(lo);
}

char* tolua_getstring (int narg, const char* def)
{
 lua_Object lo = lua_getparam(narg);
 return lo==LUA_NOOBJECT ? (char*)def : lua_getstring(lo);
}

void* tolua_getuserdata (int narg, const void* def)
{
 lua_Object lo = lua_getparam(narg);
 return lo==LUA_NOOBJECT ? (void*)def : lua_getuserdata(lo);
}

void* tolua_getusertype (int narg, const void* def)
{
 lua_Object lo = lua_getparam(narg);
 return lo==LUA_NOOBJECT ? (void*)def : lua_getuserdata(lo);
}

lua_Object tolua_getobject (int narg, lua_Object def)
{
 lua_Object lo = lua_getparam(narg);
 return lo==LUA_NOOBJECT ? def : lo;
}

double tolua_getfieldnumber (lua_Object lo, int index, double def)
{
 double v;
 lua_beginblock();
 lua_pushobject(lo);
 lua_pushnumber(index);
 lo = lua_gettable();
 v = lua_isnil(lo) ? def : lua_getnumber(lo);
 lua_endblock();
 return v;
}

char* tolua_getfieldstring (lua_Object lo, int index, const char* def)
{
 char* v;
 lua_beginblock();
 lua_pushobject(lo);
 lua_pushnumber(index);
 lo = lua_gettable();
 v = lua_isnil(lo) ? (char*)def : lua_getstring(lo);
 lua_endblock();
 return v;
}

void* tolua_getfielduserdata (lua_Object lo, int index, const void* def)
{
 void* v;
 lua_beginblock();
 lua_pushobject(lo);
 lua_pushnumber(index);
 lo = lua_gettable();
 v = lua_isnil(lo) ? (void*)def : lua_getuserdata(lo);
 lua_endblock();
 return v;
}

void* tolua_getfieldusertype (lua_Object lo, int index, const void* def)
{
 void* v;
 lua_beginblock();
 lua_pushobject(lo);
 lua_pushnumber(index);
 lo = lua_gettable();
 v = lua_isnil(lo) ? (void*)def : lua_getuserdata(lo);
 lua_endblock();
 return v;
}

lua_Object tolua_getfieldobject (lua_Object lo, int index, lua_Object def)
{
 lua_pushobject(lo);
 lua_pushnumber(index);
 lo = lua_gettable();
 return lua_isnil(lo) ? def : lo;
}


void tolua_pushnumber (double value)
{
 lua_pushnumber(value);
}

void tolua_pushstring (const char* value)
{
 if (value == NULL)
  lua_pushnil();
 else
  lua_pushstring((char*)value);
}

void tolua_pushuserdata (const void* value)
{
 if (value == NULL)
  lua_pushnil();
 else
  lua_pushuserdata((void*)value);
}

void tolua_pushusertype (const void* value, int tag)
{
 if (value == NULL)
  lua_pushnil();
 else
  lua_pushusertag((void*)value,tag);
}

void tolua_pushobject (lua_Object lo)
{
 lua_pushobject(lo);
}

void tolua_pushfieldnumber (lua_Object lo, int index, double v)
{
 lua_pushobject(lo);
 lua_pushnumber(index);
 tolua_pushnumber(v);
 lua_settable();
}

void tolua_pushfieldstring (lua_Object lo, int index, char* v)
{
 lua_pushobject(lo);
 lua_pushnumber(index);
 tolua_pushstring(v);
 lua_settable();
}

void tolua_pushfielduserdata (lua_Object lo, int index, void* v)
{
 lua_pushobject(lo);
 lua_pushnumber(index);
 tolua_pushuserdata(v);
 lua_settable();
}

void tolua_pushfieldusertype (lua_Object lo, int index, void* v, int tag)
{
 lua_pushobject(lo);
 lua_pushnumber(index);
 tolua_pushusertype(v,tag);
 lua_settable();
}

#if 0
void tolua_pushfieldclone (lua_Object lo, int index, void* v, unsigned int size, int tag)
{
 lua_pushobject(lo);
 lua_pushnumber(index);
 tolua_pushclone(v,size,tag);
 lua_settable();
}
#endif

void tolua_pushfieldobject (lua_Object lo, int index, lua_Object tf)
{
 lua_pushobject(lo);
 lua_pushnumber(index);
 tolua_pushobject(tf);
 lua_settable();
}
