/*
	$Id: cl_gwidget.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "../API/GUI/cl_gwidget.h"
#include <assert.h>


CL_GWidget::CL_GWidget() :
   CL_GObject()
{

}


CL_GWidget::CL_GWidget(CL_GWidget* parent, int x, int y, int w, int h) :
  CL_GObject(),
  CL_GRect(x,y,w,h)
{

  assert(parent != 0);

  parent_ = parent;
  rect_ = CL_GRect(x,y,w,h);
  window_ = CL_GRect (0,0,w,h);

  initMembers();

  //surface in memory
//  surface_ = new USurface(w, h);
//	surface_ = CL_Surface::create(new CL_Canvas(w, h, 1, 0xff000000, 0x00ff0000, 0x0000ff00, 0), true);
	surface_ = CL_Surface::create(new CL_Canvas(w, h), true);
  assert(surface_ != 0);
  
  //register with parent and retrieve parentSurface_
  parentSurface_ = parent_->insertChild(this);

	// register slots
	register_slot(cl_slot(CL_GWidget::forceUpdate));	
	register_slot(cl_slot(CL_GWidget::show));
	register_slot(cl_slot(CL_GWidget::hide));
	register_slot(cl_slot(CL_GWidget::close));
}

CL_GWidget::~CL_GWidget()
{
//   //do not use close() here !! because it calls the parent
//   //which at this moment is destructing too !!!!
//   if(!closed_)
//     close();

//  debugN(17,cerr << name() << " has been hit for death." << endl;);
	TRACEMSG("CL_GWidget" << " widget zapped")

  closed_ = true;

  if(parent_ != 0)
    parent_->removeChild(this);

  CL_GWidget *childPtr;

  while(!childs_.empty())
    {
      childPtr = childs_.front();
      childs_.pop_front();
      //deleting a child modifies list childs_ (cia removeChild)
      //this is why the local copy childPtr is needed here
      delete childPtr;
    }

	//free background (if existing)
//	if(backgrnd_ != 0)
//		delete backgrnd_;

	//free own surface
	delete surface_;

//  debugN(17,cerr << name() << " vanishes." << endl;);
	TRACEMSG("CL_GWidget" << " dissapears in a poof of smoke")

}

void
CL_GWidget::initMembers()
{

  haveFocus_ = false;
  drawBackground_ = true;
  needsUpdate_ = true;
  needsReblit_ = true;
  hidden_ = false;
  hideRequest_ = false;
  closed_ = false;
  disableRequest_ = false;
  disabled_ = false;
  tileBackground_ = true;
/* lp
  color_.r = 0;
  color_.g = 0;
  color_.b = 0;
*/
  backgrnd_ = 0;
}

void CL_GWidget::setBackground(const CL_Surface* backgrnd, bool tile)
{

  ///
  tileBackground_ = tile;
  // we don't copy the background....
  backgrnd_ = backgrnd;


  //we need update
  needsUpdate_ = true;
}

void CL_GWidget::setColor(float r, float g, float b, float a)
{
	this->r = r;
	this->g = g;
	this->b = b;
	this->a = a;
	
	use_color_ = true;
	
	//we need update
	needsUpdate_ = true;	
}

/*
void
CL_GWidget::setAlpha(unsigned char alpha)
{
  if(surface_ != 0)
    surface_->setAlpha(alpha);

  needsUpdate_ = true;

}
*/
void CL_GWidget::blit()
{
//  debugN(17,cerr << this->name() << " is blitted." << endl;);
	TRACEMSG("CL_GWidget" << " blitted")

  if(!hidden_)
    {
      dirtyRects_.push_back(globalCoord(window_));

      blit_complete(parentSurface_);

      //blit the childs
      std::list<CL_GWidget*>::iterator childItr_;
      childItr_ = childs_.begin();
      while(childItr_ != childs_.end())
	{
	  (*childItr_)->blit();
	  childItr_ ++;
	}

    }

}

//void CL_GWidget::blit_complete(USurface* target)
void CL_GWidget::blit_complete(CL_Surface *target)
{
/*lp
  //backBuffer_ blit if surface_ may contain transparent areas
  if((target != 0) && (surface_->usesTransparency()))
    {
      //FIXME, this is not always correct !!
      parent_->surface_->blit(target, globalCoord(window_),rect_);

    }
*/
  //blit ourself
//lp surface_->blit(target, globalCoord(window_), window_);
	CL_GPoint p = globalCoord(window_).upperLeft();
	surface_->put_target(p.x, p.y, 0, target->get_provider());
}


void CL_GWidget::show()
{
  hidden_ = false;
  needsUpdate_ = true;

  std::list<CL_GWidget*>::iterator childItr_;
  childItr_ = childs_.begin();
  while(childItr_ != childs_.end())
    {
      (*childItr_)->show();
      childItr_ ++;
    }
}

void CL_GWidget::hide()
{
  hideRequest_ = true;
  needsUpdate_ = true;

  std::list<CL_GWidget*>::iterator childItr_;
  childItr_ = childs_.begin();
  while(childItr_ != childs_.end())
    {
      (*childItr_)->hide();
      childItr_ ++;
    }
}

void CL_GWidget::enable()
{
  disabled_ = false;
  //this is *needed* is a hidden widget gets disabled this flag
  //will never be reset, because update_ is not entered
  disableRequest_ = false;
  needsUpdate_ = true;

  std::list<CL_GWidget*>::iterator childItr_;
  childItr_ = childs_.begin();
  while(childItr_ != childs_.end())
    {
      (*childItr_)->enable();
      childItr_ ++;
    }
}

void CL_GWidget::disable()
{
  disableRequest_ = true;
  needsUpdate_ = true;

  std::list<CL_GWidget*>::iterator childItr_;
  childItr_ = childs_.begin();
  while(childItr_ != childs_.end())
    {
      (*childItr_)->disable();
      childItr_ ++;
    }
}

void CL_GWidget::close()
{
  hide();
  //no chance...  every story has an end
  hidden_ = true;
  closed_ = true;

}

void CL_GWidget::update()
{
  if(closed_)
    {
      delete this;
      return;
    }

  if(disabled_)
    return;

  if(hideRequest_)
    {
      hideRequest_ = false;
      hidden_ = true;

      //force parent to update
      if(parent_ != 0)
	parent_->forceUpdate(1);
    }

  if(disableRequest_)
    {
      disableRequest_ = false;
      disabled_ = true;
    }
	

//  debugN(17,cerr << this->name() << ".update()" << endl;);
	TRACEMSG("CL_GWidget" << ".update()")

  //remember update flag
  bool update_ = needsUpdate_;
  ///child list iterator.
  std::list<CL_GWidget*>::iterator childItr_;

  //create this child
  createChild();

  //blit the necessary parts
	blit_dirty(parentSurface_);

  needsReblit_ = false;

  childItr_ = childs_.begin();
  std::list<CL_GWidget*> closeList;

  while(childItr_ != childs_.end())
    {

      //we must not call update() of an closed widget here
      //since closed widgets selfdestruct when calling update()
      if(!(*childItr_)->isClosed())
	{
	
	  if((*childItr_)->needsUpdate())
	    {
	       (*childItr_)->update();
	    }
	  else
	    if(update_)
	      (*childItr_)->blit();
	}
      else
	{
	  closeList.push_back(*childItr_);
	}

      (*childItr_)->addUpdateRects(dirtyRects_);

      childItr_ ++;
    }

  //kill the ones which are already dead (?)
  CL_GWidget *childPtr;
  while(!closeList.empty())
    {
      childPtr = closeList.front();
      closeList.pop_front();
      //deleting a child modifies list badly
      //this is why the local copy childPtr is needed here
      delete childPtr;
    }


}


void CL_GWidget::blit_dirty(CL_Surface *target)
{
	if(!dirtyRects_.empty())
	{
		CL_GRect dest;
		CL_GRect src;
		CL_SurfaceProvider *prov = target->get_provider();
		
		std::list<CL_GRect>::iterator itr = dirtyRects_.begin();		
		while(itr != dirtyRects_.end())
		{
			src = localCoord(*itr);
			dest = *itr;
//	  debugN(17,cerr <<name()<<" blits(" << src << " >>> "<<dest << endl;);
			TRACEMSG("CL_GWidget" << "blits")
//lp	  surface_->blit(target, dest, src);
//todo: lp		surface_->put_target(0, 0, 0, target->get_provider());
			prov->push_clip_rect(
				CL_ClipRect(
					dest.upperLeft().x,
					dest.upperLeft().y,
					dest.lowerRight().x,
					dest.lowerRight().y));
			surface_->put_target(dest.upperLeft().x, dest.upperLeft().y, 0, prov);
			prov->pop_clip_rect();

			//surface_->put_target(dest.upperLeft().x, dest.upperLeft().y, 0, prov);
			itr++;
		}
	}
}

void CL_GWidget::createChild()
{

  if(needsUpdate_)
    {
//      debugN(17,cerr << this->name() << ".createChild()" << endl;);
		TRACEMSG("CL_GWidget" << ".createChild()")
      if(!hidden_)
	{
  	
	  //create widget tree
	  create();

	  //when disabled greyout the widget
	  if(disabled_)
	    {
// 	      UPoint p;
// 	      UColor col = UColor(8,8,8);
// 	      for(p.x=0; p.x < surface_->width(); p.x+=2)
// 		for(p.y=0; p.y < surface_->height(); p.y+=2)
// 		  surface_->setPixel(p,col);
/*lp	
	      USurface* grey = new USurface(surface_->width(), surface_->height());
	      grey->fill(UColor(64,64,64));
	      grey->setAlpha(50);
	      grey->blit(surface_);

	      delete grey;
*/
	    }


	}
      else
	{
  	
//	  debugN(17,cerr << name() << " now wears the Cap of Invisibility."
//				<< endl;);
		TRACEMSG("CL_GWidget" << "is now invisible")

	  //create transparent bitmap
//lp	  surface_->fill(UColor(0,0,0));

	}
      needsUpdate_ = false;
    }
}

void CL_GWidget::create()
{

//  debugN(17,cerr << this->name() << ".create() " << endl;);
	TRACEMSG("CL_GWidget" << ".create()")

	dirtyRects_.push_back(globalCoord(window_));

	if(!hidden_)
	{   //draw a rect that represents the widget
		CL_SurfaceProvider* prov = surface_->get_provider();
//    	int col = CL_Color::get_color(prov, 255, 255, 255, 255);
		if (use_color_)
		{
			prov->fill_rect(0, 0, width()-1, height()-1, r, g, b, a);
		}
//lp todo: reload is expensive and the sublasses of this widget calls reload as well. Resolve
// this so that reload is called once.
//  	surface_->reload();

/* lp
      surface_->fill(color_);

      //backBuffer_ blit if surface_ may contain transparent areas
      if((parentSurface_ != 0) && (surface_->usesTransparency()))
	{
     	  parent_->surface_->blit(parentSurface_, globalCoord(window_),rect_);
	}
*/

	if(backgrnd_ != 0)
	{
		//clip backgrnd or tile it ...
		CL_GRect dest;
		CL_GRect src;
		int w,h,x,y;
	
		int nx, ny;
	

		if(surface_->get_width() < backgrnd_->get_width())
			w = surface_->get_width();
		else
			w = backgrnd_->get_width();

		if(surface_->get_height() < backgrnd_->get_height())
			h = surface_->get_height();
		else
			h = backgrnd_->get_height();

		if(tileBackground_)
		{
			//tile it
			if(h > 0)
				ny = surface_->get_height() / h + ((surface_->get_height() % h)?1:0);
			else
				ny = 0;
			if(w > 0)
				nx = surface_->get_width() / w + ((surface_->get_width() % w)?1:0);
			else
				nx = 0;
	
			for(y = 0; y < ny; y++)
			{
				for(x = 0; x < nx; x++)
				{
					int xsize = (w<(surface_->get_width()-x*w)) ?
						w : (surface_->get_width()-x*w);
					int ysize = (h<(surface_->get_height()-y*h)) ?
						h : (surface_->get_height()-y*h);
		
				//target, destrect, srcrect
//				backgrnd_->blit(surface_,
//					CL_GRect(x*w,y*h,xsize,ysize),
//					CL_GRect(0,0,xsize,ysize),
//todo: fix tiling code
					//backgrnd_->put_target( x*w, y*h, 0, prov);
				}
			}
		} // end if(tilebackground)
		else
		{
			//center background
			x = (surface_->get_width() -w )/2;
			y = (surface_->get_height() -h)/2;
//			backgrnd_->blit(surface_, CL_GRect(x,y,w,h), CL_GRect(0,0,w,h));
			//backgrnd_->put_target(x, y, 0, prov);
		}
	} // end if(tilebackground == 0)

	} // end if (!hidden)
	else
	{
		//this is for debugging
		assert(false);
	}
}



bool CL_GWidget::needsUpdate()
{

  //this widget tree is hidden or even closed
  //it surely needs no update
  if(closed_ || hidden_ || disabled_ )
    return false;

  //do we ourselves need screen update ?
  if (needsUpdate_ || needsReblit_)
    return true;

  //no ?, perhaps any child widget ?

  ///child list iterator.
  std::list<CL_GWidget*>::iterator childItr_;
  bool needed = false;
  childItr_ = childs_.begin();
  while(childItr_ != childs_.end())
    {
      if((*childItr_)->needsUpdate())
	{
	  needed = true;
	  //ok, we need update, no need to search any further
	  break;
	}
      childItr_++;
    }

  return needed;

}


//USurface* CL_GWidget::insertChild(CL_GWidget* child)
CL_Surface* CL_GWidget::insertChild(CL_GWidget* child)
{

  assert(child != 0);
  assert(surface_ != 0);

//lp  USurface* bitmap;
	CL_Surface *bitmap;

  //if we are the rootwidget, our own surface_ is returned
  //else parentSurface_ is returned, thus all widgets blit to root !

	if(parentSurface_ == 0)
		bitmap = surface_;
	else
		bitmap = parentSurface_;

  std::list<CL_GWidget*>::iterator itr = childs_.begin();
  while(itr != childs_.end())
    {
      if(*itr == child)
	break;
      itr++;
    }

//	assert(itr != childs_.end());
/*
  if(itr != childs_.end())
    {
      debugN(17,cerr << name() << ": child "<< child->name()
	    << " already inserted." << endl;);

      return bitmap;
    }
*/
  childs_.push_back(child);

  return bitmap;

}

void CL_GWidget::removeChild(CL_GWidget* child)
{
  assert(child != 0);
  childs_.remove(child);
}




CL_GRect CL_GWidget::globalCoord (CL_GRect local)
{
  //transform local to glocal coords
  CL_GRect  result;

  if(parent_ != 0)
    result = parent_->globalCoord(local);
  else
    result = local;

  result.translate(-window_.upperLeft().x + rect_.upperLeft().x,
		   -window_.upperLeft().y + rect_.upperLeft().y);


  return result;
}

CL_GRect CL_GWidget::localCoord (CL_GRect global)
{
  //transform global to local coords
  CL_GRect  result;

  if(parent_ != 0)
    result = parent_->localCoord(global);
  else
    result = global;

  result.translate(window_.upperLeft().x - rect_.upperLeft().x ,
		   window_.upperLeft().y - rect_.upperLeft().y );


  return result;
}

void CL_GWidget::addUpdateRects(std::list<CL_GRect> &updateRects)
{
  //this removes all elements in dirtyRects_

  while(!dirtyRects_.empty())
    {
      updateRects.push_back(dirtyRects_.front());
      dirtyRects_.pop_front();
    }
}

bool CL_GWidget::handleEvent(const CL_GEvent* event)
{

  if(hidden_ || closed_ || disabled_)
    return false;

  bool handled = false;

  if(event->type() == CL_GEvent::MOUSEMOTION)
    {
      haveFocus_ = globalCoord(window_).contains(((CL_GMouseMotionEvent *)event)->position());
    }

  if(event->type() == CL_GEvent::MOUSEBUTTON)
    {
      haveFocus_ = globalCoord(window_).contains(((CL_GMouseButtonEvent *)event)->position());
    }

  //can we handle this event ?
  handled = processEvent(event);

  if(!handled)
    {
      //no ?, perhaps any child ?

      ///child list iterator.
      std::list<CL_GWidget*>::iterator childItr_;
      childItr_ = childs_.begin();
      while(childItr_ != childs_.end())
	{
	  if((*childItr_)->handleEvent(event))
	    {
	      handled = true;
	      break;
	    }
	  childItr_++;
	}
    }

  return handled;
}

/* close slot */
//SLOT_IMPL(CL_GWidget, close, int)
void CL_GWidget::close(int n)
{
  close();
}

/* hide slot */
//SLOT_IMPL(CL_GWidget, hide, int)
void CL_GWidget::hide(int n)
{
  hide();
}

/* show slot */
//SLOT_IMPL(CL_GWidget, show, int)
void CL_GWidget::show(int n)
{
  show();
}

/* forceUpdate slot */
//SLOT_IMPL(CL_GWidget, forceUpdate, int)
void CL_GWidget::forceUpdate(int data)
{
  switch(data)
    {
    case 0: 
      needsReblit_ = true;
      break;
    case 1:
      needsUpdate_ = true;
      break;
    default:
      needsReblit_ = true;
      break;
   }
}











































