/*
	$Id: cl_gpushbutton.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include <API/GUI/cl_gpushbutton.h>
#include <API/GUI/cl_gpoint.h>

CL_GPushButton::CL_GPushButton(CL_GWidget *parent, int x, int y, int w, int h, int id) :
	CL_GButton(parent, x, y, w, h, id),
	up_pic(0),
	down_pic(0)
{}

CL_GPushButton::~CL_GPushButton()
{
}

void CL_GPushButton::create()
{
	CL_SurfaceProvider *prov = surface_->get_provider();
	
	CL_GPoint p1(0,0);
	CL_GPoint p2(0, surface_->get_height()-1);
	CL_GPoint p3(surface_->get_width()-1, surface_->get_height()-1);
	CL_GPoint p4(surface_->get_width()-1, 0);
	float light=1.0;
	float dark=0.5;
	
	if (isPressed)
	{
		if (down_pic != 0)
			backgrnd_ = down_pic;	
	}
	else
	{
		if (up_pic != 0)
			backgrnd_ = up_pic;	
	}

	// todo: Why draw the default CL_GWidget? commented lp	
	CL_GButton::create();
	
	if (isPressed)
	{
		if (down_pic == 0)
		{
			prov->draw_line(p1.x, p1.y, p2.x, p2.y, light, light, light, 1.0);
			prov->draw_line(p2.x, p2.y, p3.x, p3.y, light, light, light, 1.0);
			prov->draw_line(p3.x, p3.y, p4.x, p4.y, dark, dark, dark, 1.0);
			prov->draw_line(p4.x, p4.y, p1.x, p1.y, dark, dark, dark, 1.0);	
			
			p1+=CL_GPoint(1, 1);
			p2+=CL_GPoint(1, -1);
			p3+=CL_GPoint(-1, -1);
			p4+=CL_GPoint(-1, 1);

			prov->draw_line(p1.x, p1.y, p2.x, p2.y, light, light, light, 1.0);
			prov->draw_line(p2.x, p2.y, p3.x, p3.y, light, light, light, 1.0);
			prov->draw_line(p3.x, p3.y, p4.x, p4.y, dark, dark, dark, 1.0);
			prov->draw_line(p4.x, p4.y, p1.x, p1.y, dark, dark, dark, 1.0);	
		}
	}
	else
	{
		if (up_pic == 0)
		{
			prov->draw_line(p1.x, p1.y, p2.x, p2.y, dark, dark, dark, 1.0);
			prov->draw_line(p2.x, p2.y, p3.x, p3.y, dark, dark, dark, 1.0);
			prov->draw_line(p3.x, p3.y, p4.x, p4.y, light, light, light, 1.0);
			prov->draw_line(p4.x, p4.y, p1.x, p1.y, light, light, light, 1.0);	
			
			p1 += CL_GPoint(1, 1);
			p2 += CL_GPoint(1, -1);
			p3 += CL_GPoint(-1, -1);
			p4 += CL_GPoint(-1, 1);

			prov->draw_line(p1.x, p1.y, p2.x, p2.y, dark, dark, dark, 1.0);
			prov->draw_line(p2.x, p2.y, p3.x, p3.y, dark, dark, dark, 1.0);
			prov->draw_line(p3.x, p3.y, p4.x, p4.y, light, light, light, 1.0);
			prov->draw_line(p4.x, p4.y, p1.x, p1.y, light, light, light, 1.0);		
		}
	}

	surface_->reload();
}

void CL_GPushButton::set_up_pic(const CL_Surface *surf)
{
	up_pic = surf;
}

void CL_GPushButton::set_down_pic(const CL_Surface *surf)
{
	down_pic = surf;
}












