/*
	$Id: mutex_pthread.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <pthread.h>
#include "mutex_pthread.h"

// We need to do this because the posix threads library under linux obviously
// suck:
extern "C"
{
	int pthread_mutexattr_setkind_np(pthread_mutexattr_t *attr, int kind);
}

CL_Mutex *CL_Mutex::create()
{
	return new CL_Mutex_Posix;
}

CL_Mutex_Posix::CL_Mutex_Posix()
{
	pthread_mutexattr_t attr;
	pthread_mutexattr_init(&attr);
	pthread_mutexattr_setkind_np(&attr, PTHREAD_MUTEX_RECURSIVE_NP);
	pthread_mutex_init(&mutex, &attr);
	pthread_mutexattr_destroy(&attr);

	pthread_cond_init(&cond,0);
}

CL_Mutex_Posix::~CL_Mutex_Posix()
{
	pthread_mutex_destroy(&mutex);
	pthread_cond_destroy(&cond);
}
	
void CL_Mutex_Posix::enter()
{
	pthread_mutex_lock(&mutex);
}

void CL_Mutex_Posix::leave()
{
	pthread_mutex_unlock(&mutex);
}


void CL_Mutex_Posix::wait()
{
	pthread_cond_wait(&cond,&mutex);
}


void CL_Mutex_Posix::notify()
{
	pthread_cond_signal(&cond);
}

void CL_Mutex_Posix::notify_all()
{
	pthread_cond_broadcast(&cond);
}
