/*
	$Id: implementation_xwindow.cpp,v 1.2 2000/04/25 21:40:16 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Initialization functions for XWindow implementation.

*/

#include "Core/precomp.h"

#ifdef USE_X11

#include "implementation_xwindow.h"
#include "API/Core/Display/display.h"
#include "Core/Display/X11/display_xwindow.h"
#include "API/Core/Input/input.h"
#include "Core/Input/X11/mouse_x11.h"
#include "Core/Input/X11/keyboard_x11.h"
#include "Core/Input/X11/joystick_linux.h"
#include "implementation.h"

// dlopen clanlib interface:
extern "C"
{
	DL_PREFIX char* clan_module_identify()
	{
		return "Native X11 target";
	}

	DL_PREFIX char* clan_module_abbreviation()
	{
		return "x11";
	}

	DL_PREFIX void clan_module_init()
	{
		CL_Implementation_XWindow::add_display();
	}
}

char* xwindow_identify()
{
	return clan_module_identify();
}

char* xwindow_abbreviation()
{
	return clan_module_abbreviation();
}

void xwindow_init()
{
	clan_module_init();
}

bool CL_Implementation_XWindow::initialized = false;
Display *CL_Implementation_XWindow::dpy = NULL;
Window CL_Implementation_XWindow::root;
int CL_Implementation_XWindow::default_scr;
int CL_Implementation_XWindow::display_counter=0;

static CL_Implementation_XWindow impl_xwindow;

CL_Implementation_XWindow::~CL_Implementation_XWindow()
{
	while (display_counter > 0) clean_up();
}

bool CL_Implementation_XWindow::init()
{
	if (initialized) return true;

	dpy = XOpenDisplay(NULL);
	if (dpy == NULL) return false;

	default_scr = DefaultScreen(dpy);
	root = RootWindow(dpy, default_scr);

	return true;
}

void CL_Implementation_XWindow::clean_up()
{
	if (display_counter == 0) return; // nothing to clean up...

	display_counter--;
	if (display_counter>0) return;

	XCloseDisplay(dpy);
}

void CL_Implementation_XWindow::add_display()
{
	if (init() == false)
	{
		std::cout << "ClanLib: Failed to open display. No XWindow display available."
				 << std::endl;
	}

	CL_XWindow_DisplayCard *card = new CL_XWindow_DisplayCard(
		dpy,
		root,
		display_counter);

	CL_Display::cards.push_back(card);

	CL_Input::keyboards.push_back(new CL_XWindowKeyboard(card));
	CL_Input::pointers.push_back(new CL_Mouse_XWin(card));

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)

	for (int i=0; i<8; i++)
	{
		CL_LinuxJoystick *joy = new CL_LinuxJoystick();
		if (joy->init(i))
			CL_Input::joysticks.push_back(joy);
		else
			delete joy;
	}

#endif

	display_counter+=3;
}

#endif
