/*
	$Id: soundbuffer_stream.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <API/Core/System/error.h>
#include <API/Core/Sound/sound.h>
#include <API/Core/Sound/soundbuffer.h>
#include <API/Core/Sound/soundbuffer_session.h>
#include <API/Core/Sound/stream_soundprovider.h>
#include <Core/Sound/Generic/cardsession_manager.h>
#include <Core/Sound/Generic/cardsoundbuffer_playback.h>
#include <Core/Sound/Generic/soundbuffer_stream.h>
#include <Core/Sound/Generic/soundcard_generic.h>

CL_SoundBuffer *CL_SoundBuffer::create(
	CL_StreamSoundProvider *provider, bool delete_provider)
{
	return new CL_SoundBuffer_Generic_Stream(provider, delete_provider);
}

CL_SoundBuffer_Generic_Stream::CL_SoundBuffer_Generic_Stream(
	CL_StreamSoundProvider *_provider, bool _delete_provider)
{
	provider = _provider;
	delete_provider = _delete_provider;

	volume = -1; 
	pan = -1; 
	frequency = -1; 
}

CL_SoundBuffer_Generic_Stream::~CL_SoundBuffer_Generic_Stream()
{
	int num = CL_Sound::cards.size();
	for (int i=0; i<num; i++)
	{
		CL_SoundCard_Generic *gen = (CL_SoundCard_Generic *) CL_Sound::cards[i];
		gen->manager->remove_soundbuffer_playbacks(this);
	}

	if (delete_provider) delete provider;
}

CL_StreamSoundProvider *CL_SoundBuffer_Generic_Stream::get_stream_provider() const
{
	return provider;
}

int CL_SoundBuffer_Generic_Stream::get_length() const
{
	return -1;
}

int CL_SoundBuffer_Generic_Stream::get_num_samples() const
{
	return -1;
}

int CL_SoundBuffer_Generic_Stream::get_frequency() const
{
	return frequency;
}

bool CL_SoundBuffer_Generic_Stream::set_frequency(int new_freq)
{
	frequency = new_freq;
	return true;
}

float CL_SoundBuffer_Generic_Stream::get_volume() const
{
	return volume;
}

bool CL_SoundBuffer_Generic_Stream::set_volume(float new_volume)
{
	volume = new_volume;
	return true;
}

float CL_SoundBuffer_Generic_Stream::get_pan() const
{
	return pan;
}

bool CL_SoundBuffer_Generic_Stream::set_pan(float new_pan)
{
	pan = new_pan;
	return true;
}

bool CL_SoundBuffer_Generic_Stream::is_playing(CL_SoundBuffer_Session **session, CL_SoundCard *card) const
{
	if (session != NULL)
	{
		return (*session)->is_playing();
	}
	else
	{
		if (card != NULL)
		{
			return ((CL_SoundCard_Generic *) card)->manager->is_soundbuffer_playing((CL_SoundBuffer *) this);
		}
		else
		{
			if (CL_Sound::get_current_card() != NULL)
			{
				return ((CL_SoundCard_Generic *) CL_Sound::get_current_card())->manager->is_soundbuffer_playing((CL_SoundBuffer *) this);
			}
			else
			{
				return false;
			} 
		}
	}
	return true;
}

void CL_SoundBuffer_Generic_Stream::stop(CL_SoundCard *card)
{
	if (card != NULL)
	{
		((CL_SoundCard_Generic *) card)->manager->remove_soundbuffer_playbacks((CL_SoundBuffer *) this);
	}
	else
	{
		if (CL_Sound::get_current_card() != NULL)
		{
			((CL_SoundCard_Generic *) CL_Sound::get_current_card())->manager->remove_soundbuffer_playbacks((CL_SoundBuffer *) this);
		}
	}
}

CL_SoundBuffer_Session CL_SoundBuffer_Generic_Stream::play(bool looping, CL_SoundCard *card)
{
	if (card == NULL) card = CL_Sound::get_current_card();

	CL_SoundBuffer_Session ret(prepare(looping, card));
	ret.set_looping(looping);
	ret.play();

	return ret;
}

CL_SoundBuffer_Session CL_SoundBuffer_Generic_Stream::prepare(bool looping, CL_SoundCard *card)
{
	if (card == NULL) card = CL_Sound::get_current_card();

	CL_CardSoundBuffer_Playback *playback =
		((CL_SoundCard_Generic *) card)->
			create_cardsoundbuffer_playback_streamed(this);

	CL_SoundBuffer_Session ret(
		CL_SoundBuffer_Session(
			((CL_SoundCard_Generic *) card)->manager->add_playback(playback), card));



	if (pan == -1) pan = 0;
	if (volume == -1) volume = 1;

	ret.set_volume(volume);
	ret.set_pan(pan);
	ret.set_looping(looping);
	if (frequency != -1) ret.set_frequency(frequency);

	return ret;
}
