/*
	$Id: resourcetype_string.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		String resource type

*/

#include "Core/precomp.h"
#include <API/Core/Resources/resourcetype_string.h>

CL_Res_String::CL_Res_String() : CL_ResourceType("string")
{
}

CL_Resource *CL_Res_String::create_from_location(
	std::string name,
	std::string location,
	CL_ResourceOptions *options,
	CL_ResourceManager *parent)
{
	return new CL_StringResource(name, location, options, parent);
}

CL_Resource *CL_Res_String::create_from_serialization(
	std::string name,
	CL_ResourceManager *parent)
{
	return new CL_StringResource(name, parent);
}

std::string CL_Res_String::load(
	std::string name,
	CL_ResourceManager *manager,
	std::string _default)
{
	try
	{
		CL_StringResource *res = (CL_StringResource *) manager->get_resource(name);
		return res->get_value();
	}
	catch (CL_Error err)
	{
		return _default;
	}
}

std::string CL_Res_String::load(
	std::string name,
	CL_ResourceManager *manager)
{
	CL_StringResource *res = (CL_StringResource *) manager->get_resource(name);
	return res->get_value();
}
