#ifndef header_network_delivery_win32
#define header_network_delivery_win32

#include <list>
#include <Core/Network/Generic/network_delivery_impl.h>
#include <Core/Network/Generic/network_delivery_socket.h>

class CL_Connections_Win32 : public CL_ConnectionProvider
{
protected:
	std::list<CL_UniformSocket *> connections;
	std::list<CL_UniformUDPConnection *> udp_connections;
	std::list<CL_UniformAcceptSocket *> accepting_connections;

public:
	CL_Connections_Win32();
	virtual ~CL_Connections_Win32();

	virtual CL_Connection *get_client() { return NULL; }
	virtual CL_UDPConnection *create_udp_connection(unsigned int port);
	virtual CL_Connection *create_tcp_connection(
		int ip_addr,
		int port);
	virtual CL_Connection *accept();
	virtual void start_accept_on_port(int port);
	virtual void stop_accept_on_port(int port);
	virtual void wait_for_connection_data(CL_Mutex *mutex);
	virtual void remove_connection(CL_Connection *removed_connection);
};

#endif