
#ifndef header_netgame_client
#define header_netgame_client

#include <string>
#include <list>
#include <queue>

#include "netgame_generic.h"

class CL_NetChannelQueue_Client;

class CL_NetGame_Client : public CL_NetGame_Generic, CL_Runnable
{
public:
	CL_NetGame_Client(
		int ip_addr,
		int port,
		std::string &game_id,
		CL_Network_Generic *network);
	virtual ~CL_NetGame_Client();

	virtual const CL_NetComputer *get_server() const;
	virtual const CL_NetGroup *get_all() const;
	
	virtual bool peek(int channel) const;
	virtual CL_NetMessage receive(int channel, int timeout=-1);

	virtual void send(
		const int dest_channel,
		const CL_NetComputer *dest,
		const CL_NetMessage &message,
		bool reliable = true);

	virtual void send(
		const int dest_channel,
		const CL_NetGroup *dest,
		const CL_NetMessage &message,
		bool reliable = true);

	virtual CL_NetComputer *receive_computer_leave();
	virtual const CL_NetComputer *receive_computer_join();
	virtual const CL_NetComputer *receive_computer_rejoin();
	virtual bool receive_game_closed();
	virtual int access_status(int channel) const;
	virtual bool is_writable(int channel) const;
	virtual bool is_readable(int channel) const;

	// Client side only:
	virtual int receive_access_changed();

	// Server side only:
	virtual void set_access(
		int channel,
		const CL_NetComputer *computer,
		int access_rights=ACCESS_CHANNEL_READ|ACCESS_CHANNEL_WRITE);
	virtual void set_access(
		int channel,
		const CL_NetGroup *group,
		int access_rights=ACCESS_CHANNEL_READ|ACCESS_CHANNEL_WRITE);

protected: // from CL_NetGame_Generic
	virtual void keep_alive();

private: // implementation helper functions:
	CL_NetChannelQueue_Client *find_queue(int netchannel) const;
	CL_NetChannelQueue_Client *create_queue(int netchannel);

private:
	CL_Connection *tcp_connection;
	CL_UDPConnection *udp_connection;
	std::list<CL_NetChannelQueue_Client*> netchannels;
	std::queue<CL_NetChannelQueue_Client*> access_queue;
	int our_id;
	
	CL_NetComputer server;
	CL_NetGroup all;
	
private: // multithread:
	CL_Mutex *mutex;
	CL_Thread *thread;
	volatile bool exit_thread;

	virtual void run();
};

class CL_NetChannelQueue_Client : public std::queue<CL_NetMessage>
{
public:
	int channel_id;
	int access;
};

#endif
