/*
	$Id: keyboard_be.h,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef header_keyboard_be
#define header_keyboard_be


#include "API/Core/Input/inputbutton.h"
#include "API/Core/Input/keyboard.h"
#include "Core/System/Be/app_beos.h"

#include <Message.h>

class CL_InputButton_BeKeyboard : public CL_InputButton
{
public:
	CL_InputButton_BeKeyboard(int key, bool *keymap);
	bool is_pressed();

private:
	int key;
	bool *keymap;
};

class CL_InputBuffer_BeKeyboard : public CL_InputBuffer
{
public:
	CL_InputBuffer_BeKeyboard();
	virtual ~CL_InputBuffer_BeKeyboard();

	int peek_key() const;
	int get_key();
	int keys_left();
	void clear();
	int get_ascii();
	unsigned int get_unicode();

	void add_key(int key);
	
private:
	int m_begin;
	int m_end;
	int *m_buffer;
	int m_buffer_size;
};

class CL_BeKeyboard : public CL_Keyboard, CL_System_KeepAlive
{
public:
	CL_BeKeyboard();
	virtual ~CL_BeKeyboard();

	virtual char *get_name() const;

	virtual int get_num_buttons() const;
	virtual CL_InputButton *get_button(int button_num);

	virtual int get_num_axes() const;
	virtual CL_InputAxis *get_axis(int axis_num);

	virtual int get_num_hats() const;
	virtual CL_InputHat *get_hat(int hat_num);

	virtual int get_num_buffers() const;
	virtual CL_InputBuffer *get_buffer(int buffer_num);

	virtual int get_num_cursors() const;
	virtual CL_InputCursor *get_cursor(int cursor_num);

	virtual bool keep_alive();

	void handle_key( BMessage* msg, bool down );
	void handle_modifiers( BMessage* msg );

private:
	bool keymap[128];
	
	char translate(int kb_value);
	
	CL_Array<CL_InputButton_BeKeyboard> buttons;
	CL_InputBuffer_BeKeyboard buffer;
};

#endif
