/*
	$Id: file_inputprovider.h,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		File input source provider, part of the i/o data component.

*/

#ifndef header_file_inputprovider
#define header_file_inputprovider

#include "API/Core/IOData/inputsource.h"

#include <stack>

class CL_InputSourceProvider_File : public CL_InputSourceProvider
{
public:
	virtual CL_InputSource *open_source(const char *filename);
	virtual CL_InputSourceProvider *clone();
};

class CL_InputSource_File : public CL_InputSource
{
protected:
	std::stack<int> stack;
	std::string filename;
	FILE *filehandle;
	int filesize;

public:
	CL_InputSource_File(const char *filename);
	CL_InputSource_File(const CL_InputSource_File *source);
	virtual ~CL_InputSource_File();

	// Change input data endianess (defaults to little endian)
	virtual void set_system_mode();
	virtual void set_big_endian_mode();
	virtual void set_little_endian_mode();

	// read 32 bit integer:
	virtual int read_int32();
	virtual unsigned int read_uint32();

	// read 16 bit short:
	virtual short read_short16();
	virtual unsigned short read_ushort16();

	// read 8 bit char:
	virtual char read_char8();
	virtual unsigned char read_uchar8();

	virtual float read_float32();

	// read larger amounts of data (no endian and 64 bit conversion):
	// returns num bytes actually read
	virtual int read(void *data, int size);

	virtual void open();
	virtual void close();

	// Make a copy of the current InputSource, standing at the same position.
	virtual CL_InputSource *clone() const;

	// Returns current position in input source
	virtual int tell() const;
	virtual void seek(int pos, SeekEnum seek_type);

	// Returns the size of the input source
	virtual int size() const;

	virtual std::string read_string();

	virtual void push_position();
	virtual void pop_position();
};

#endif
