/*
	$Id: displaycard_win32compatible.cpp,v 1.2 2000/04/18 12:33:17 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"
#include "displaycard_win32compatible.h"
#include "Core/System/Win32/init_win32.h"

CL_DisplayCard_Win32Compatible::CL_DisplayCard_Win32Compatible(int card_no)
: CL_DisplayCard_Generic(card_no)
{
	hwnd = NULL;
}

CL_DisplayCard_Win32Compatible::~CL_DisplayCard_Win32Compatible()
{
	destroy_window();
}

void CL_DisplayCard_Win32Compatible::destroy_window()
{
	if (hwnd == NULL) return;

	BOOL res = DestroyWindow(hwnd);
	cl_assert(res == TRUE);
	hwnd = NULL;
}

extern LONG WINAPI MainMessageHandler(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

void CL_DisplayCard_Win32Compatible::create_window(
	int width,
	int height,
	int bpp,
	bool full_screen,
	bool allow_resize)
{
	WNDCLASS wndclass;

	wndclass.style = 0;
	wndclass.lpfnWndProc = (WNDPROC) MainMessageHandler;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = CL_System_Win32::hInstance;
	wndclass.hIcon = NULL;
	wndclass.hCursor = LoadCursor (NULL,IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wndclass.lpszMenuName = CL_ClanApplication::app->get_title();
	wndclass.lpszClassName = CL_ClanApplication::app->get_title();

	cl_assert(RegisterClass(&wndclass)>0);

	int x = 0;
	int y = 0;

	if (full_screen)
	{
		width = GetSystemMetrics(SM_CXSCREEN);
		height = GetSystemMetrics(SM_CYSCREEN);
	}
	else
	{
		int scr_width = GetSystemMetrics(SM_CXSCREEN);
		int scr_height = GetSystemMetrics(SM_CYSCREEN);

		x = scr_width/2 - width/2;
		y = scr_height/2 - height/2;
	}

	int style;
	if (full_screen)
	{
		style = WS_POPUP;
	}
	else if (allow_resize)
	{
		style = WS_POPUP | WS_SYSMENU | WS_CAPTION | WS_SIZEBOX;
	}
	else
	{
		style = WS_POPUPWINDOW | WS_CAPTION;
	}

	hwnd = CreateWindow(
		CL_ClanApplication::app->get_title(),
		CL_ClanApplication::app->get_title(),
		style,
		x,
		y,
		width,
		height,
		NULL,
		NULL,
		CL_System_Win32::hInstance,
		NULL);

	cl_assert(hwnd != NULL);

	// Ok. Thanks to microsoft, the titlebar is part of the window!
	// I havn't been able to find a function that gets the size of the titlebar (probably just me),
	// so I do some clientrect calcing. Someone please fix this, and in the flip_display()
	// function too.

	if (!full_screen)
	{
		RECT client_rect;
		GetClientRect(hwnd, &client_rect);

		POINT Pt;
		Pt.x=0;
		Pt.y=0;
		ClientToScreen(hwnd,&Pt);

		RECT dest_rect;
		GetWindowRect(hwnd, &dest_rect);

		// Add windows title bar height and the +3 is for the windows bottom border
		// I don't think there's another way of doing it
		dest_rect.bottom += (Pt.y-dest_rect.top)+3;

		// Add window left/right borders width
		dest_rect.right   += (Pt.x-dest_rect.left)*2;

		SetWindowPos(
			hwnd,
			HWND_TOP,
			dest_rect.left,
			dest_rect.top,
			dest_rect.right - dest_rect.left,
			dest_rect.bottom - dest_rect.top,
			SWP_NOZORDER | SWP_FRAMECHANGED);
	}

	ShowWindow(hwnd, SW_SHOW);
	UpdateWindow(hwnd);
}

void CL_DisplayCard_Win32Compatible::show_system_cursor()
{
	ShowCursor(TRUE);
}

void CL_DisplayCard_Win32Compatible::hide_system_cursor()
{
	ShowCursor(FALSE);
}
