/*
	$Id: cl_gtextfield.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_TEXTFIELD_H
#define CL_TEXTFIELD_H

#include "cl_gwidget.h"

class CL_GTextfield : public CL_GWidget
{
public:
	enum align_t {ALIGN_LEFT, ALIGN_CENTER, ALIGN_RIGHT};
	CL_GTextfield(CL_GWidget* parent, int x, int y, int w, int h, CL_Font *font=0);
	virtual ~CL_GTextfield();
	virtual bool processEvent(const CL_GEvent *e);
	void set_align(align_t align) { this->align = align; needsUpdate_ = true; };
	const char * get_text(){ return text.c_str();}
	DEF_SIGNAL_1(CL_GTextfield::changed,CL_GTextfield *);
	DEF_SIGNAL_1(CL_GTextfield::enter,CL_GTextfield *);
	DEF_SLOT_1(keypress, int);
	
  
protected:
	virtual void create();
	
	CL_Font*		text_font;
	align_t			align;
	int			 cursor_pos;
	bool 			draw_cursor;
	bool  cursor;
	bool block_input;
	std::string 		 text;
	CL_Surface* 		 surface;
};
#endif



