/*
	$Id: texture.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="OpenGL"

#ifndef header_texture
#define header_texture

#include "../core.h"

class CL_Texture
//: Texture loading class for OpenGL.
// <p>This class can load the image(s) from surface provider into OpenGL
// textures.</p>
//
// <p>This class works just like a <a class="CL_Surface">surface</a>, except that it
// requires the image width to be 2^n.</p>
{
public:
	static CL_Texture *create(CL_SurfaceProvider *provider, bool delete_provider=false);
	// Creates a texture from a surface provider.
	//!param: provider - Surface provider to use as image source.
	//!param: delete_provider - If true, surface provider will be deleted
	//!param:                   when the texture is deleted.

	static CL_Texture *load(const char *id, CL_ResourceManager *manager);
	// Load the texture from a surface resource.
	//!param: id - Resource ID of the surface resource.
	//!param: manager - Resource manager used to load the resource from.

	virtual ~CL_Texture() { ; }

	virtual void bind(int texture_no=0)=0;
	// Bind the texture in OpenGL.
	//!param: texture_no - Subframe in the provider to bind.

	virtual CL_SurfaceProvider *get_provider() const =0;
	// Returns the surface provider.

	virtual void reload()=0; 
//: Forces surface to reload texture data from provider.

	virtual int get_width() const =0;
//: Returns the width of the surface
//!retval: Width of the texture.

	virtual int get_height() const =0;
//: Returns the height of the texture
//!retval: Height of the texture.

	virtual int get_no_textures() const =0;
//: Returns the number of subtextures in the texture
//!retval: Number of subtextures in texture.

	virtual void flush(CL_DisplayCard *card = NULL)=0;
//: completely flushes textures (removes from video/system-memory)
};

#endif
