/*
	$Id: resourceoptions.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Resources"

#ifndef header_resourceoptions
#define header_resourceoptions

#include "../../stl.h"

class CL_ResourceManager;
class CL_ResourceOption;

class CL_ResourceOptions
{
public:
	CL_ResourceOptions(CL_ResourceManager *parent);
	~CL_ResourceOptions();
	
	std::list<CL_ResourceOption*> *get_options();

	void add(CL_ResourceOption *option);
	std::string get_value(std::string option);
	CL_ResourceOption *get_option(std::string option);
	bool exists(std::string option);

private:
	std::list<CL_ResourceOption*> options;
	CL_ResourceManager *parent;
};

#endif
