/*
	$Id: inputaxis_group.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="InputConverters"

#ifndef header_inputaxis_group
#define header_inputaxis_group

#include "../../stl.h"
#include "../Input/inputaxis.h"

class CL_InputAxis_Group : public CL_InputAxis
//: CL_InputAxis container class. Groups a set of axes.
{
	std::list<CL_InputAxis*> axes;
public:
	void add(CL_InputAxis *add_axis)
	{
		axes.push_back(add_axis);
	}
	//: Adds a input axis to the group.
	//!param: add_axis - Axis to be added.

	void remove(CL_InputAxis *remove_axis)
	{
		axes.remove(remove_axis);
	}
	//: Removes a input axis from the group.
	//!param: remove_axis - Axis to be removed.

	virtual float get_pos()
	{
		float pos = 0;

		for (
			std::list<CL_InputAxis *>::iterator it = axes.begin();
			it != axes.end();
			it++)
		{
			pos += (*it)->get_pos();
		}

		if (pos > 1) pos = 1;
		if (pos < -1) pos = -1;

		return pos;
	}
	//: Returns the current axis position. This is calculated by sumarizing
	//: all the input axes positions and return that value.
	//!retval: Current axis position.
};

#endif
