/*
	$Id: inputaxis_basic.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="InputConverters"

#ifndef header_inputaxis_basic
#define header_inputaxis_basic

class CL_InputAxis_Basic : public CL_InputAxis
//: CL_InputAxis interface used to ease manual implementation of an input axis.
{
protected:
	float pos;
	
public:
	CL_InputAxis_Basic()
	{
		pos = 0;
	}
	//: Constructs an axis standing in center position.
	
	CL_InputAxis_Basic(float pos)
	{
		this->pos = pos;
	}
	//: Constructs an axis standing in position 'pos'.
	//!param: pos - Initial axis position. Range -1 to 1.
	
	virtual ~CL_InputAxis_Basic() {;}

	virtual float get_pos()
	{
		return pos;
	}
	//: Returns the current axis position.
	//!retval: The current axis position.
	
	void set_pos(float pos)
	{
		this->pos = pos;
	}
	//: Set the current axis position.
	//!param: pos - New axis position. Range -1 to 1.
};

#endif
