/*
	$Id: input.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Input"

#ifndef header_input
#define header_input

#include "../../stl.h"

class CL_InputDevice;
class CL_Keyboard;

#include "input_events.h"

class CL_Input
//: Input component class.
// CL_Input is the access point to keyboards, joysticks and (mouse) pointers.
{
public:
	virtual ~CL_Input() { return; }

	static std::vector<CL_Keyboard*> keyboards;
	//: List of keyboards available.
	
	static std::vector<CL_InputDevice*> joysticks; // joysticks and gamepads
	//: List of joysticks and gamepads available.
	
	static std::vector<CL_InputDevice*> pointers; // mice and digitizers
	//: List of mice and digitizers available.

	static CL_EventChain_ButtonPress chain_button_press;
	//: Chain of event listeners told about a button press.

	static CL_EventChain_ButtonRelease chain_button_release;
	//: Chain of event listeners told about a button release.

	static CL_EventChain_MouseMove chain_mouse_move;
	//: Chain of event listeners told about a mouse movement.

	static CL_EventChain_MouseEnter chain_mouse_enter;
	//: Chain of event listeners told about a mouse entering the window area.

	static CL_EventChain_MouseExit chain_mouse_exit;
	//: Chain of event listeners told about a mouse leaving the window area.
};

#endif
