/*
	The minimum requirements needed by every ClanLib application.

	note that the try/catch is not required but should be added 
	to every ClanLib application.
*/

#include <ClanLib/core.h>

class MinimumApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Minimum application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		try
		{
			std::cout << "Hello World" << std::endl;
		}
		catch (CL_Error err)
		{
			std::cout << "Exception caught: " << err.message.c_str() << std::endl;
			return -1;
		}
		return 0;
	}
} app;
