/*
        fill_rect test app.
*/

#include <ClanLib/core.h>

class DrawingApp : public CL_ClanApplication
{
public:
        virtual char *get_title() { return "Drawing application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}
	
	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}
        
        virtual int main(int, char **)
        {
                try
                {
                        CL_Display::set_videomode(320,200,32);

                        CL_Canvas *src_canvas = new CL_Canvas(320, 200);

                        src_canvas->fill_rect(0, 0, 319, 199, 1.0, 1.0, 1.0, 1.0);
			src_canvas->fill_rect(0, 0, 40, 40,     1.0, 0.0,0.0, 0.5);
			src_canvas->fill_rect(50, 50, 70, 70,   0.0, 1.0,0.0, 0.5);
			src_canvas->fill_rect(80, 80, 100, 100, 0.0, 0.0,1.0, 0.5);
			src_canvas->draw_line(0,0,100,100,0.0,0.0,1.0,0.6);

                        CL_Surface *src_surface = CL_Surface::create(src_canvas);
			src_surface->put_screen(0,0);                   
			                            
                        CL_Display::flip_display();
                        CL_System::sleep(1500);

                        CL_Display::fill_rect(0, 0, 319, 199, 1.0, 1.0, 1.0, 1.0);
			CL_Display::fill_rect(0, 0, 40, 40,     1.0, 0.0,0.0, 0.5);
			CL_Display::fill_rect(50, 50, 70, 70,   0.0, 1.0,0.0, 0.5);
			CL_Display::fill_rect(80, 80, 100, 100, 0.0, 0.0,1.0, 0.5);
                        CL_Display::draw_line(0,0,100,100,0.0,0.0,1.0,0.6);
                
                        CL_Display::flip_display();
                        CL_System::sleep(1500);

                        delete src_canvas;
                        delete src_surface;
                    
                        return 0;
                }
                catch (CL_Error err)
                {
                        cout << "Exception caught: " << err.message.c_str() << endl;
                        return -1;
                }
                return -1;
        }
} app;


