// Configure.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Configure.h"
#include "configure_wizard.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigureApp

BEGIN_MESSAGE_MAP(CConfigureApp, CWinApp)
	//{{AFX_MSG_MAP(CConfigureApp)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigureApp construction

CConfigureApp::CConfigureApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CConfigureApp object

CConfigureApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CConfigureApp initialization

BOOL CConfigureApp::InitInstance()
{
	// Standard initialization

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	CConfigureWizard wizard;
	m_pMainWnd = &wizard;

	int nResponse = wizard.DoModal();
	if (nResponse == ID_WIZFINISH)
	{
		write_dsw();

		// Write all library project files:
		std::list<std::string> libs_list_shared;
		std::list<std::string> libs_list_release;
		std::list<std::string> libs_list_debug;
		std::list<std::string> defines_list;

		libs_list_shared.push_back("winmm.lib");
		libs_list_shared.push_back("ddraw.lib");
		libs_list_shared.push_back("dsound.lib");
		libs_list_shared.push_back("dinput.lib");
		libs_list_shared.push_back("wsock32.lib");
		libs_list_shared.push_back("hermes.lib");
		libs_list_shared.push_back("zlib.lib");

		defines_list.push_back("USE_OPENGL");
		defines_list.push_back("USE_NETWORK");

		if (wizard.m_Page2.m_disptarget == 1) // if use PTC
		{
			libs_list_shared.push_back("ptc.lib");
			defines_list.push_back("USE_PTC");
		}

		write_dsp(
			"Core",
			"clanCore",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));
		//clean the lib list
		while (libs_list_shared.empty() == false) libs_list_shared.pop_front();
		while (libs_list_debug.empty() == false) libs_list_debug.pop_front();
		while (libs_list_release.empty() == false) libs_list_release.pop_front();

		// libs for clanGL
		libs_list_shared.push_back("OpenGL32.lib");
		libs_list_shared.push_back("GLU32.lib");
		
		write_dsp(
			"GL",
			"clanGL",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));
		//clean the lib list
		while (libs_list_shared.empty() == false) libs_list_shared.pop_front();

/*		
		write_dsp(
			"GUI",
			"clanGUI",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));
*/
		write_dsp(
			"Lua",
			"clanLua",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));


		libs_list_shared.push_back("Imagick.lib");

		write_dsp(
			"Magick",
			"clanMagick",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));

		while (libs_list_shared.empty() == false) libs_list_shared.pop_front();


		write_dsp(
			"MikMod",
			"clanMikMod",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));

		write_dsp(
			"MPEG",
			"clanMPEG",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));

		write_dsp(
			"PNG",
			"clanPNG",
			libs_list_shared,
			libs_list_release,
			libs_list_debug,
			defines_list,
			std::string(wizard.m_Page3.m_output_include),
			std::string(wizard.m_Page3.m_output_lib));

		/* TODO: Update the following registry keys:

		\\LOCAL MACHINE\Software\Microsoft\DevStudio\6.0\Build System\Components\Platforms\Win32 (x86)\Directories\Include Dirs
		\\LOCAL MACHINE\Software\Microsoft\DevStudio\6.0\Build System\Components\Platforms\Win32 (x86)\Directories\Library Dirs
		\\LOCAL MACHINE\Software\Microsoft\DevStudio\6.0\Build System\Components\Platforms\Win32 (x86)\Directories\Path Dirs
		\\LOCAL MACHINE\Software\Microsoft\DevStudio\6.0\Build System\Components\Platforms\Win32 (x86)\Directories\Source Dirs
		*/
	}
	else if (nResponse == IDCANCEL)
	{
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Visual C++ workspace write routine.

void CConfigureApp::write_dsw()
{
	ofstream dsw("ClanLib.dsw");

	dsw << "Microsoft Developer Studio Workspace File, Format Version 6.00" << endl;
	dsw << "# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!" << endl;
	dsw << endl;
	dsw << "###############################################################################" << endl;
	dsw << endl;

	begin_project(dsw, "AlphaTest", ".\\Documentation\\Examples\\AlphaTest\\AlphaTest.dsp");
	add_project_dependency(dsw, "clanCore");
	add_project_dependency(dsw, "clanMagick");
	end_project(dsw);

	begin_project(dsw, "GL", ".\\Documentation\\Examples\\GL\\GL.dsp");
	add_project_dependency(dsw, "clanCore");
	add_project_dependency(dsw, "clanGL");
	end_project(dsw);

	begin_project(dsw, "InitDisplay", ".\\Documentation\\Examples\\InitDisplay\\InitDisplay.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);

	begin_project(dsw, "InputDevices", ".\\Documentation\\Examples\\InputDevices\\InputDevices.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);

	begin_project(dsw, "Magick", ".\\Documentation\\Examples\\Magick\\Magick.dsp");
	add_project_dependency(dsw, "clanCore");
	add_project_dependency(dsw, "clanMagick");
	end_project(dsw);

	begin_project(dsw, "Minimum", ".\\Documentation\\Examples\\Minimum\\Minimum.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);


	begin_project(dsw, "Mouse", ".\\Documentation\\Examples\\Mouse\\Mouse.dsp");

	add_project_dependency(dsw, "clanCore");

	end_project(dsw);




	begin_project(dsw, "StaticSoundProvider", ".\\Documentation\\Examples\\StaticSoundProvider\\StaticSoundProvider.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);

	begin_project(dsw, "StreamSoundProvider", ".\\Documentation\\Examples\\StreamSoundProvider\\StreamSoundProvider.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);

	begin_project(dsw, "NetChannel", ".\\Documentation\\Examples\\NetChannel\\NetChannel.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);

	begin_project(dsw, "Surface", ".\\DOCUMENTATION\\EXAMPLES\\Surface\\Surface.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);

	begin_project(dsw, "SurfaceProvider", ".\\DOCUMENTATION\\EXAMPLES\\SurfaceProvider\\SurfaceProvider.dsp");
	add_project_dependency(dsw, "clanCore");
	end_project(dsw);

	begin_project(dsw, "clanCore", ".\\Sources\\clanCore.dsp");
	end_project(dsw);

	begin_project(dsw, "clanGL", ".\\Sources\\clanGL.dsp");
	end_project(dsw);
/*
	begin_project(dsw, "clanGUI", ".\\Sources\\clanGUI.dsp");
	end_project(dsw);
*/
	begin_project(dsw, "clanLua", ".\\Sources\\clanLua.dsp");
	end_project(dsw);

	begin_project(dsw, "clanMPEG", ".\\Sources\\clanMPEG.dsp");
	end_project(dsw);

	begin_project(dsw, "clanMagick", ".\\Sources\\clanMagick.dsp");
	end_project(dsw);

	begin_project(dsw, "clanMikMod", ".\\Sources\\clanMikMod.dsp");
	end_project(dsw);

	begin_project(dsw, "clanPNG", ".\\Sources\\clanPNG.dsp");
	end_project(dsw);

	dsw << "Global:" << endl;
	dsw << endl;
	dsw << "Package=<5>" << endl;
	dsw << "{{{" << endl;
	dsw << "}}}" << endl;
	dsw << endl;
	dsw << "Package=<3>" << endl;
	dsw << "{{{" << endl;
	dsw << "}}}" << endl;
	dsw << endl;
	dsw << "###############################################################################" << endl;
	dsw << endl;
}

void CConfigureApp::begin_project(ofstream &dsw, const char *name, const char *filename)
{
	dsw << "Project: \"" << name << "\"=\"" << filename << "\" - Package Owner=<4>" << endl;
	dsw << endl;
	dsw << "Package=<5>" << endl;
	dsw << "{{{" << endl;
	dsw << "}}}" << endl;
	dsw << endl;
	dsw << "Package=<4>" << endl;
	dsw << "{{{" << endl;
}

void CConfigureApp::end_project(ofstream &dsw)
{
	dsw << "}}}" << endl;
	dsw << endl;
	dsw << "###############################################################################" << endl;
	dsw << endl;
}

void CConfigureApp::add_project_dependency(ofstream &dsw, const char *dep_name)
{
	dsw << "    Begin Project Dependency" << endl;
	dsw << "    Project_Dep_Name " << dep_name << endl;
	dsw << "    End Project Dependency" << endl;
}

/////////////////////////////////////////////////////////////////////////////
// Visual C++ project write routine.
/*
intermediate_dir, output_dir, target_dir, use_debug_libs
libs_list, defines_list
*/
void CConfigureApp::write_dsp(
	std::string name,
	std::string libname,
	std::list<std::string> &libs_list_shared,
	std::list<std::string> &libs_list_release,
	std::list<std::string> &libs_list_debug,
	std::list<std::string> &defines_list,
	std::string output_include_dir,
	std::string output_lib_dir)
{
	CString filename = "Sources/";
	filename += libname.c_str();
	filename += ".dsp";

	ofstream dsp(filename);

	dsp << "# Microsoft Developer Studio Project File - Name=\"" << libname.c_str() << "\" - Package Owner=<4>" << endl;
	dsp << "# Microsoft Developer Studio Generated Build File, Format Version 6.00" << endl;
	dsp << "# ** DO NOT EDIT **" << endl;
	dsp << endl;
	dsp << "# TARGTYPE \"Win32 (x86) Static Library\" 0x0104" << endl;
	dsp << endl;
	dsp << "CFG=" << libname.c_str() << " - Win32 Release" << endl;
	dsp << "!MESSAGE This is not a valid makefile. To build this project using NMAKE," << endl;
	dsp << "!MESSAGE use the Export Makefile command and run" << endl;
	dsp << "!MESSAGE " << endl;
	dsp << "!MESSAGE NMAKE /f \"" << libname.c_str() << ".mak\"." << endl;
	dsp << "!MESSAGE " << endl;
	dsp << "!MESSAGE You can specify a configuration when running NMAKE" << endl;
	dsp << "!MESSAGE by defining the macro CFG on the command line. For example:" << endl;
	dsp << "!MESSAGE " << endl;
	dsp << "!MESSAGE NMAKE /f \"" << libname.c_str() << ".mak\" CFG=\"" << libname.c_str() << " - Win32 Release\"" << endl;
	dsp << "!MESSAGE " << endl;
	dsp << "!MESSAGE Possible choices for configuration are:" << endl;
	dsp << "!MESSAGE " << endl;
	dsp << "!MESSAGE \"" << libname.c_str() << " - Win32 Release\" (based on \"Win32 (x86) Static Library\")" << endl;
	dsp << "!MESSAGE \"" << libname.c_str() << " - Win32 Debug\" (based on \"Win32 (x86) Static Library\")" << endl;
	dsp << "!MESSAGE " << endl;
	dsp << endl;
	dsp << "# Begin Project" << endl;
	dsp << "# PROP AllowPerConfigDependencies 0" << endl;
	dsp << "# PROP Scc_ProjName \"\"" << endl;
	dsp << "# PROP Scc_LocalPath \"\"" << endl;
	dsp << "CPP=cl.exe" << endl;
	dsp << "RSC=rc.exe" << endl;
	dsp << endl;
	dsp << "!IF  \"$(CFG)\" == \"" << libname.c_str() << " - Win32 Release\"" << endl;
	dsp << endl;
	dsp << "# PROP BASE Use_MFC 0" << endl;
	dsp << "# PROP BASE Use_Debug_Libraries 0" << endl;
	dsp << "# PROP BASE Output_Dir \"../Release\"" << endl;
	dsp << "# PROP BASE Intermediate_Dir \"../Release/" << libname.c_str() << "\"" << endl;
	dsp << "# PROP BASE Target_Dir \"\"" << endl;
	dsp << "# PROP Use_MFC 0" << endl;
	dsp << "# PROP Use_Debug_Libraries 0" << endl;
	dsp << "# PROP Output_Dir \"../Release\"" << endl;
	dsp << "# PROP Intermediate_Dir \"../Release/" << libname.c_str() << "\"" << endl;
	dsp << "# PROP Target_Dir \"\"" << endl;
	dsp << "# ADD BASE CPP /nologo /W3 /GX /O2 /D \"WIN32\" /D \"NDEBUG\" /D \"_WINDOWS\" /YX /FD /c" << endl;

	dsp << "# ADD CPP /nologo /W3 /GX /O2 /I \".\" /D \"NDEBUG\" /D \"WIN32\" /D \"_WINDOWS\"";
	{
		for (
			std::list<std::string>::iterator it = defines_list.begin();
			it != defines_list.end();
			it++)
		{
			dsp << " /D \"" << (*it).c_str() << "\"";
		}
	}

	if (name == "clanCore") // use precomp headers in clanCore.
		dsp << " /Yu\"Core/precomp.h\" /FD /c" << endl;
	else
		dsp << " /YX /FD /c" << endl;

	dsp << "# ADD BASE RSC /l 0x409 /d \"NDEBUG\"" << endl;
	dsp << "# ADD RSC /l 0x409 /d \"NDEBUG\"" << endl;
	dsp << "BSC32=bscmake.exe" << endl;
	dsp << "# ADD BASE BSC32 /nologo" << endl;
	dsp << "# ADD BSC32 /nologo" << endl;
	dsp << "LIB32=link.exe -lib" << endl;
	dsp << "# ADD BASE LIB32 /nologo" << endl;

	dsp << "# ADD LIB32 ";
	{
		for (
			std::list<std::string>::iterator it = libs_list_shared.begin();
			it != libs_list_shared.end();
			it++)
		{
			dsp << " " << (*it).c_str() << "";
		}
	}
	{
		for (
			std::list<std::string>::iterator it = libs_list_release.begin();
			it != libs_list_release.end();
			it++)
		{
			dsp << " " << (*it).c_str() << "";
		}
	}
	dsp << " /nologo /out:\"" << output_lib_dir.c_str() << "\\" << libname.c_str() << ".lib\"" << endl;

	dsp << "# Begin Special Build Tool" << endl;
	dsp << "SOURCE=\"$(InputPath)\"" << endl;
	dsp << "PostBuild_Desc=Installing library and API headers..." << endl;
	dsp << "PostBuild_Cmds=call install_" << libname.c_str() << ".bat\t";
//	dsp << "copy ..\\Release\\" << libname.c_str() << ".lib \"" << output_lib_dir.c_str() << "\"";

	// create the install_libname.bat installation batch file:
	{
		CString bat_file = "Sources\\install_";
		bat_file += libname.c_str();
		bat_file += ".bat";

		ofstream bat(bat_file);

		CString instdir = output_include_dir.c_str();
		instdir += "\\ClanLib";
		install_mkdir(bat, "API", instdir);
		install_copydir(bat, "API", instdir);
	}

	dsp << endl;
	dsp << "# End Special Build Tool" << endl;

	dsp << endl;
	dsp << "!ELSEIF  \"$(CFG)\" == \"" << libname.c_str() << " - Win32 Debug\"" << endl;
	dsp << endl;
	dsp << "# PROP BASE Use_MFC 0" << endl;
	dsp << "# PROP BASE Use_Debug_Libraries 1" << endl;
	dsp << "# PROP BASE Output_Dir \"../Debug\"" << endl;
	dsp << "# PROP BASE Intermediate_Dir \"../Debug/" << libname.c_str() << "\"" << endl;
	dsp << "# PROP BASE Target_Dir \"\"" << endl;
	dsp << "# PROP Use_MFC 0" << endl;
	dsp << "# PROP Use_Debug_Libraries 1" << endl;
	dsp << "# PROP Output_Dir \"../Debug\"" << endl;
	dsp << "# PROP Intermediate_Dir \"../Debug/" << libname.c_str() << "\"" << endl;
	dsp << "# PROP Target_Dir \"\"" << endl;
	dsp << "# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D \"WIN32\" /D \"_DEBUG\" /D \"_WINDOWS\" /YX /FD /GZ /c" << endl;


	dsp << "# ADD CPP /nologo /W3 /Gm /GX /ZI /Od /I \".\" /D \"NDEBUG\" /D \"WIN32\" /D \"_WINDOWS\"";
	{
		for (
			std::list<std::string>::iterator it = defines_list.begin();
			it != defines_list.end();
			it++)
		{
			dsp << " /D \"" << (*it).c_str() << "\"";
		}
	}

	if (name == "clanCore") // use precomp headers in clanCore.
		dsp << " /Yu\"Core/precomp.h\" /FD /GZ /c" << endl;
	else
		dsp << " /YX /FD /GZ /c" << endl;

	dsp << "# ADD BASE RSC /l 0x409 /d \"_DEBUG\"" << endl;
	dsp << "# ADD RSC /l 0x409 /d \"_DEBUG\"" << endl;
	dsp << "BSC32=bscmake.exe" << endl;
	dsp << "# ADD BASE BSC32 /nologo" << endl;
	dsp << "# ADD BSC32 /nologo" << endl;
	dsp << "LIB32=link.exe -lib" << endl;
	dsp << "# ADD BASE LIB32 /nologo" << endl;

	dsp << "# ADD LIB32 ";
	{
		for (
			std::list<std::string>::iterator it = libs_list_shared.begin();
			it != libs_list_shared.end();
			it++)
		{
			dsp << " " << (*it).c_str() << "";
		}
	}
	{
		for (
			std::list<std::string>::iterator it = libs_list_debug.begin();
			it != libs_list_debug.end();
			it++)
		{
			dsp << " " << (*it).c_str() << "";
		}
	}
//	dsp << " /nologo /out:\"../Debug/" << libname.c_str() << "d.lib\"" << endl;
	dsp << " /nologo /out:\"" << output_lib_dir.c_str() << "\\" << libname.c_str() << "d.lib\"" << endl;

	dsp << "# Begin Special Build Tool" << endl;
	dsp << "SOURCE=\"$(InputPath)\"" << endl;
	dsp << "PostBuild_Desc=Installing library and API headers..." << endl;
	dsp << "PostBuild_Cmds=call install_" << libname.c_str() << ".bat\t";

//	dsp << "copy ..\\Debug\\" << libname.c_str() << "d.lib \"" << output_lib_dir.c_str() << "\"";

	dsp << endl;
	dsp << "# End Special Build Tool" << endl;

	dsp << endl;
	dsp << "!ENDIF " << endl;
	dsp << endl;
	dsp << "# Begin Target" << endl;
	dsp << endl;
	dsp << "# Name \"" << libname.c_str() << " - Win32 Release\"" << endl;
	dsp << "# Name \"" << libname.c_str() << " - Win32 Debug\"" << endl;

	// Generate list of source files:
	begin_group(dsp, "API");
	begin_group(dsp, name.c_str());
	CString api_dir = "API/";
	api_dir += name.c_str(); // eg. API/Core/
	generate_dir(dsp, api_dir, "");
	end_group(dsp);

	api_dir += ".h"; // eg. api/core.h
	api_dir.MakeLower();
	add_file(dsp, api_dir);
	add_file(dsp, "API/stl.h");
	end_group(dsp);

	begin_group(dsp, "Sources");
	generate_dir(dsp, name.c_str(), " files");
	end_group(dsp);

	// End .dsp file:
	dsp << "# End Target" << endl;
	dsp << "# End Project" << endl;
}

void CConfigureApp::generate_dir(ofstream &dsp, const char *dir, const CString &postfix)
{
	CString path = dir;
	if (path.GetAt(path.GetLength() - 1) != '/') path += '/';

	WIN32_FIND_DATA	data;
	HANDLE handle = FindFirstFile("./Sources/" + path + "*.*", &data);
	if (handle == INVALID_HANDLE_VALUE) return;

	static const char *exclude_from_build[] =
	{
		".",
		"..",
		"CVS",
		"Be",
		"X11",
		"GGI",
		"Svgalib",
		"FBDev",
		"TTY",
		"Unix",
		"ClanSound",
		"GLX",
		".#", // don't add CVS revision backups.
		"blit_gl_dynamic.cpp", // not working yet (dv)
		"netdata_controller.cpp", // this one hasn't been ported to STL yet.
		NULL
	};

	do
	{
		bool skip = false;

		for (int i=0; exclude_from_build[i] != NULL; i++)
			if (stricmp(data.cFileName, exclude_from_build[i]) == 0) skip = true;

		if (skip) continue;

		if ((data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
		{
			begin_group(dsp, data.cFileName + postfix);
			generate_dir(dsp, path + data.cFileName, postfix);
			end_group(dsp);
		}
		else
		{
			add_file(dsp, path + data.cFileName);
		}

	} while (FindNextFile(handle, &data));
}

void CConfigureApp::install_mkdir(ofstream &dsp, const char *src_dir, const char *dest_dir)
{
	dsp << "mkdir \"" << dest_dir << "\" > nul" << endl;

	CString path = src_dir;
	if (path.GetAt(path.GetLength() - 1) != '\\') path += '\\';

	CString path_dest = dest_dir;
	if (path_dest.GetAt(path_dest.GetLength() - 1) != '\\') path_dest += '\\';

	CString prefix = "Sources\\";

	WIN32_FIND_DATA	data;
	HANDLE handle = FindFirstFile(prefix + path + "*.*", &data);
	if (handle == INVALID_HANDLE_VALUE) return;

	static const char *exclude_from_build[] =
	{
		".",
		"..",
		"CVS",
		".#", // don't add CVS revision backups.
		NULL
	};

	do
	{
		bool skip = false;

		for (int i=0; exclude_from_build[i] != NULL; i++)
			if (stricmp(data.cFileName, exclude_from_build[i]) == 0) skip = true;

		if (skip) continue;

		if ((data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
		{
			CString subdir = data.cFileName;
//			dsp << "mkdir \"" << path_dest << subdir << "\"" << endl; // "\"\t";
			install_mkdir(
				dsp,
				path + subdir,
				path_dest + subdir);
		}

	} while (FindNextFile(handle, &data));
}

void CConfigureApp::install_copydir(ofstream &dsp, const char *src_dir, const char *dest_dir)
{
	CString path = src_dir;
	if (path.GetAt(path.GetLength() - 1) != '\\') path += '\\';

	CString path_dest = dest_dir;
	if (path_dest.GetAt(path_dest.GetLength() - 1) != '\\') path_dest += '\\';

	CString prefix = "Sources\\";

	WIN32_FIND_DATA	data;
	HANDLE handle = FindFirstFile(prefix + path + "*.*", &data);
	if (handle == INVALID_HANDLE_VALUE) return;

	static const char *exclude_from_build[] =
	{
		".",
		"..",
		"CVS",
		".#", // don't add CVS revision backups.
		NULL
	};

	do
	{
		bool skip = false;

		for (int i=0; exclude_from_build[i] != NULL; i++)
			if (stricmp(data.cFileName, exclude_from_build[i]) == 0) skip = true;

		if (skip) continue;

		if ((data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
		{
			CString subdir = data.cFileName;
			install_copydir(
				dsp,
				path + subdir,
				path_dest + subdir);
		}
		else
		{
			CString file = data.cFileName;
			dsp << "copy \"" << path << file << "\" \"" << path_dest << file << "\" > nul" << endl; // "\"\t";
		}

	} while (FindNextFile(handle, &data));
}

void CConfigureApp::begin_group(ofstream &dsp, const char *group_name)
{
	dsp << "# Begin Group \"" << group_name << "\"" << endl;
	dsp << endl;
	dsp << "# PROP Default_Filter \"\"" << endl;
}

void CConfigureApp::end_group(ofstream &dsp)
{
	dsp << "# End Group" << endl;
}

void CConfigureApp::add_file(ofstream &dsp, const char *filename)
{
	dsp << "# Begin Source File" << endl;
	dsp << endl;
	dsp << "SOURCE=" << filename << endl;

	if (strcmp(filename, "Core/precomp.cpp") == 0)
	{
		dsp << "# ADD CPP /Yc\"Core/precomp.h\"" << endl;
	}

	dsp << "# End Source File" << endl;
}

/////////////////////////////////////////////////////////////////////////////
// Browse helper function:

BOOL BrowseForFolder(HWND hOwner, char* szTitle, char* szRetval)
{
	BROWSEINFO		info;
	LPITEMIDLIST	itemidlist;
	char			szDirectory[_MAX_PATH];
	LPMALLOC		pMalloc;

	memset(szDirectory, '\0', _MAX_PATH);

	if (::SHGetMalloc(&pMalloc) == NOERROR)
	{
		info.hwndOwner = hOwner;
		info.pidlRoot = NULL;
		info.pszDisplayName = szDirectory;
		info.lpszTitle = szTitle;
		info.ulFlags = 0;
		info.lpfn = NULL;

		itemidlist = SHBrowseForFolder(&info);
		if (itemidlist != NULL)
		{
			SHGetPathFromIDList(itemidlist, szRetval);
			pMalloc->Free(itemidlist);
			pMalloc->Release();
			return TRUE;
		}
		else // User clicked Cancel
		{
			pMalloc->Release();
			return FALSE;
		}
	}
	else
		return FALSE;
}
