/*
	ClanLib configuration tool, unix version.
*/

#include <fstream>
#include "../../Sources/API/Core/System/clanstring.h"

#include <sys/types.h>
#include <dirent.h>

void build_vpath(ofstream &makefile);
void build_core(ofstream &makefile);
void build_gl(ofstream &makefile);


void print_dirtree(ofstream &makefile, const char *dir);
void print_core_files(ofstream &makefile, const char *dir);
void build_targets(ofstream &makefile);


static const char *exclude_from_build[] =
{
	".",
	"..",
	"Be",
	"Unix",
	"CVS",
	"netdata_controller.cpp", // this one hasn't been ported to STL yet.
	NULL
};

static const char *targets[] =
{
	"X11",
	"GGI",
	"Svgalib",
	"FBDev",
	"TTY",
	"ClanSound",
	NULL
};


void main(int argc, char **argv)
{
	ofstream makefile("Makefile.in");
	
	makefile << "# Autogenerated by build_makefile." << endl;
	makefile << endl;
	
	build_vpath(makefile);
	build_core(makefile);
	build_gl(makefile);
	build_targets(makefile);
}

void build_vpath(ofstream &makefile)
{
	makefile << "VPATH = .";
	print_dirtree(makefile, "Sources/");
	makefile << endl << endl;
}

void print_dirtree(ofstream &makefile, const char *dir)
{
	CL_String path = dir;

	DIR *handle = opendir(path);
	if (handle == NULL) return;

	while (true)
	{
		dirent *data = readdir(handle);
		if (data == NULL) break;

		bool skip = false;

		for (int i=0; exclude_from_build[i] != NULL; i++)
			if (CL_String(data->d_name).case_compare(exclude_from_build[i])) skip = true;

		for (int i=0; targets[i] != NULL; i++)
			if (CL_String(data->d_name).case_compare(targets[i])) skip = true;

		if (skip) continue;

		// I can't believe d_name is the only POSIX field in dirent!!
		// Below we are trying to determine if the file is a directory:
		DIR *is_dir = opendir(path+"/"+data->d_name);
		if (is_dir != NULL)
		{
			closedir(is_dir);

			makefile << ": \\" << endl;
			makefile << "	" << (path + data->d_name);
			print_dirtree(makefile, path + data->d_name + "/");
		}
	}
}

void build_core(ofstream &makefile)
{
	makefile << "OBJF_CORE = ";
	print_core_files(makefile, "Sources/Core/");
	makefile << endl;
}

void build_gl(ofstream &makefile)
{
	makefile << "OBJF_GL = ";
	print_core_files(makefile, "Sources/GL/");
	makefile << endl;
}

void print_core_files(ofstream &makefile, const char *dir)
{
	CL_String path = dir;

	DIR *handle = opendir(path);
	if (handle == NULL) return;

	while (true)
	{
		dirent *data = readdir(handle);
		if (data == NULL) break;

		bool skip = false;

		for (int i=0; exclude_from_build[i] != NULL; i++)
			if (CL_String(data->d_name).case_compare(exclude_from_build[i])) skip = true;

		for (int i=0; targets[i] != NULL; i++)
			if (CL_String(data->d_name).case_compare(targets[i])) skip = true;

		if (skip) continue;

		// I can't believe d_name is the only POSIX field in dirent!!
		// Below we are trying to determine if the file is a directory:
		DIR *is_dir = opendir(path+"/"+data->d_name);
		if (is_dir != NULL)
		{
			closedir(is_dir);
			print_core_files(makefile, path + data->d_name + "/");
		}
		else
		{
			CL_String name = data->d_name;
			if (name.right(4) == ".cpp")
			{
				name = name.mid(0, name.get_length()-3);
				name << "o";
		
				makefile << "\\" << endl;
				makefile << "	" << "Libs/Intermediate/" << name;
			}
		}
	}
}

void build_targets(ofstream &makefile)
{
}
