/*
	$Id: stylemanager_default.cpp,v 1.53 2001/12/29 00:01:34 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"

#include <cstdio>
#include <string>

#include "API/Display/Display/display.h"
#include "API/Display/Display/surface.h"
#include "API/Core/Resources/resource_manager.h"
#include "API/GUI/stylemanager_default.h"
#include "API/GUI/component_manager.h"

#include "stylemanager_default_generic.h"
#include "label_default.h"
#include "button_default.h"
#include "frame_default.h"
#include "combobox_default.h"
#include "image_default.h"
#include "inputbox_default.h"
#include "scrollbar_default.h"
#include "progressbar_default.h"
//#include "menubar_default.h"
//#include "menuitem_default.h"
//#include "popupmenu_default.h"
#include "checkbox_default.h"
#include "listbox_default.h"
#include "treeview_default.h"
#include "treeview_item_default.h"
#include "window_default.h"
#include "API/GUI/filedialog.h"

// Construction:

CL_StyleManager_Default::CL_StyleManager_Default(CL_ResourceManager *resources)
:
	CL_StyleManager(resources)
{
	impl = new CL_StyleManager_Default_Generic;
	impl->resources = resources;
}

CL_StyleManager_Default::~CL_StyleManager_Default()
{
	delete impl;
}

// Attributes:

const std::string &CL_StyleManager_Default::get_default_font() const
{
	return impl->default_font;
}

const std::string &CL_StyleManager_Default::get_combo_normal() const
{
	return impl->combo_normal;
}

const std::string &CL_StyleManager_Default::get_combo_toggled() const
{
	return impl->combo_toggled;
}

const std::string &CL_StyleManager_Default::get_combo_disabled() const
{
	return impl->combo_disabled;
}

const std::string &CL_StyleManager_Default::get_checkbox_checked() const
{
	return impl->checkbox_checked;
}

const std::string &CL_StyleManager_Default::get_checkbox_unchecked() const
{
	return impl->checkbox_unchecked;
}

const std::string &CL_StyleManager_Default::get_checkbox_disabled() const
{
	return impl->checkbox_disabled;
}

// Operations:

void CL_StyleManager_Default::set_default_font(const std::string &font)
{
	impl->default_font = font;
}

void CL_StyleManager_Default::set_combo_normal(const std::string &normal)
{
	impl->combo_normal = normal;
}

void CL_StyleManager_Default::set_combo_toggled(const std::string &toggled)
{
	impl->combo_toggled = toggled;
}

void CL_StyleManager_Default::set_combo_disabled(const std::string &disabled)
{
	impl->combo_disabled = disabled;
}

void CL_StyleManager_Default::set_checkbox_checked(const std::string &checked)
{
	impl->checkbox_checked = checked;
}

void CL_StyleManager_Default::set_checkbox_unchecked(const std::string &unchecked)
{
	impl->checkbox_unchecked = unchecked;
}

void CL_StyleManager_Default::set_checkbox_disabled(const std::string &disabled)
{
	impl->checkbox_disabled = disabled;
}

// Functions:

void CL_StyleManager_Default::fill_rect(int x1, int y1, int x2, int y2, GUIColor col)
{
	float r = 1.0f;
	float g = 0.0f;
	float b = 1.0f;
	float a = 1.0f;

	impl->get_color(col, r, g, b, a);

	CL_Display::fill_rect(x1, y1, x2, y2, r, g, b);
}

void CL_StyleManager_Default::draw_rect(int x1, int y1, int x2, int y2, GUIColor col)
{
	float r = 1.0f;
	float g = 0.0f;
	float b = 1.0f;
	float a = 1.0f;

	impl->get_color(col, r, g, b, a);

	CL_Display::draw_rect(x1, y1, x2, y2, r, g, b);
}

void CL_StyleManager_Default::draw_line(int x1, int y1, int x2, int y2, GUIColor col)
{
	float r = 1.0f;
	float g = 0.0f;
	float b = 1.0f;
	float a = 1.0f;

	impl->get_color(col, r, g, b, a);

	CL_Display::draw_line(x1, y1, x2, y2, r, g, b, a);
}

void CL_StyleManager_Default::draw_box(int x1, int y1, int x2, int y2, GUIColor topleft, GUIColor bottomright)
{
	float r = 1.0f;
	float g = 0.0f;
	float b = 1.0f;
	float a = 1.0f;

	impl->get_color(topleft, r, g, b, a);

	CL_Display::draw_line(x1, y1, x2 - 1, y1, r, g, b, a);
	CL_Display::draw_line(x1, y1 + 1, x1, y2 - 1, r, g, b, a);
	
	r = 1.0f;
	g = 0.0f;
	b = 1.0f;
	a = 1.0f;

	impl->get_color(bottomright, r, g, b, a);

	CL_Display::draw_line(x1 + 1, y2 - 1, x2 - 1, y2 - 1, r, g, b, a);
	CL_Display::draw_line(x2 - 1, y1 + 1, x2 - 1, y2 - 2, r, g, b, a);
}

// Overridables:

CL_Component *CL_StyleManager_Default::create_component(
	const std::string &type,
	CL_Component *parent)
{
	return CL_ComponentManager::create_component(type, parent, this);
}

void CL_StyleManager_Default::connect_styles(
	const std::string &type,
	CL_Component *owner)
{
	if (type == "label")
		owner->attach_style(new CL_Label_Default((CL_Label *) owner, this));

	else if (type == "button")
		owner->attach_style(new CL_Button_Default((CL_Button *) owner, this));

	else if (type == "frame")
		owner->attach_style(new CL_Frame_Default((CL_Frame *) owner, this));

	else if (type == "combobox")
		owner->attach_style(new CL_ComboBox_Default((CL_ComboBox *) owner, this));

	else if (type == "image")
		owner->attach_style(new CL_Image_Default((CL_Image *) owner, this));

	else if (type == "inputbox")
		owner->attach_style(new CL_InputBox_Default((CL_InputBox *) owner, this));

	else if (type == "scrollbar")
		owner->attach_style(new CL_ScrollBar_Default((CL_ScrollBar *) owner, this));

	else if (type == "progressbar")
		owner->attach_style(new CL_ProgressBar_Default((CL_ProgressBar *) owner, this));

/*	else if (type == "menubar")
		owner->attach_style(new CL_MenuBar_Default((CL_MenuBar *) owner, this));

	else if (type == "popupmenu")
		owner->attach_style(new CL_PopupMenu_Default((CL_PopupMenu *) owner, this));

	else if (type == "menuitem")
		owner->attach_style(new CL_MenuItem_Default((CL_MenuItem *) owner, this));
*/
	else if (type == "checkbox")
		owner->attach_style(new CL_CheckBox_Default((CL_CheckBox *) owner, this));

	else if (type == "listbox")
		owner->attach_style(new CL_ListBox_Default((CL_ListBox *) owner, this));

	else if (type == "treeview")
		owner->attach_style(new CL_TreeView_Default((CL_TreeView *) owner, this));

	else if (type == "treeview_item")
		owner->attach_style(new CL_TreeView_Item_Default((CL_TreeView_Item *) owner, this));

	else if (type == "window")
		owner->attach_style(new CL_Window_Default((CL_Window *) owner, this));
}
