/*
	$Id: popupmenu_default.cpp,v 1.25 2001/12/16 19:18:08 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "popupmenu_default.h"
#include "API/GUI/stylemanager_default.h"

CL_PopupMenu_Default::CL_PopupMenu_Default(
	CL_PopupMenu *_popupmenu,
	const CL_ComponentOptions &options,
	CL_StyleManager_Default *style)
:
	CL_ComponentStyle(_popupmenu),
	popupmenu(_popupmenu)
{
	this->style = style;
	
	resources = style->get_resources();

	slot_paint = popupmenu->sig_paint().connect(
		this, &CL_PopupMenu_Default::on_paint);
}

/*void CL_PopupMenu_Default::adjust_size()
{
	int max_surface_check_width = 0;
	int max_surface_icon_width = 0;
	int max_surface_submenu_width = 0;
	int max_text_width = 0;
	int max_width = 0;
	int y = 4;
	
	std::list<CL_Component *>::iterator it;
	std::list<CL_Component *> &children = popupmenu->get_children();

	// Calculate size of items
	for (
		it = children.begin();
		it != children.end();
		it++)
	{
		CL_MenuItem *menuitem = (CL_MenuItem *)(*it);
		CL_MenuItem_Default *menuitem_default = (CL_MenuItem_Default *)menuitem->get_impl();

		int surface_check_width = menuitem_default->calc_surface_check_width();
		if(surface_check_width > max_surface_check_width)
			max_surface_check_width = surface_check_width;

		int surface_icon_width = menuitem_default->calc_surface_icon_width();
		if(surface_icon_width > max_surface_icon_width)
			max_surface_icon_width = surface_icon_width;
		
		int surface_submenu_width = menuitem_default->calc_surface_submenu_width();
		if(surface_submenu_width > max_surface_submenu_width)
			max_surface_submenu_width = surface_submenu_width;

		int text_width = menuitem_default->calc_text_width();
		if(text_width > max_text_width)
			max_text_width = text_width;

		int width = menuitem_default->calc_width();
		if(width > max_width)
			max_width = width;
	}
	
	// Set size and position of items
	for (
		it = children.begin();
		it != children.end();
		it++)
	{
		CL_MenuItem *menuitem = (CL_MenuItem *)(*it);
		CL_MenuItem_Default *menuitem_default = (CL_MenuItem_Default *)menuitem->get_impl();

		int pos = 4;
		menuitem_default->set_surface_check_pos(pos);
		pos += max_surface_check_width;
		menuitem_default->set_surface_icon_pos(pos);
		pos += max_surface_icon_width;
		menuitem_default->set_text_pos(pos);
		pos += max_text_width;
		menuitem_default->set_surface_submenu_pos(pos);

//		menuitem_default->draw_submenu_icon = true;

		int height = menuitem_default->calc_height();
		
		menuitem->set_size(max_width + 4, height);
		menuitem->set_position(4, y);

		y += height;
	}

	// Resize popupmenu based on total children size
	CL_Rect pos = popupmenu->get_position();
	CL_Rect rect = popupmenu->get_children_rect();
	rect.x1 = pos.x1;
	rect.y1 = pos.y1;
	rect.x2 += pos.x1 + 4;
	rect.y2 += pos.y1 + 4;
	popupmenu->set_position(rect);
}
*/

void CL_PopupMenu_Default::on_paint()
{
	int width = popupmenu->get_width();
	int height = popupmenu->get_height();
		
	style->draw_box(0, 0, width, height, GUICOLOR_BRIGHT_SHADE, GUICOLOR_DARK_SHADE);
	style->draw_box(1, 1, width - 1, height - 1, GUICOLOR_BRIGHT_SHADE, GUICOLOR_DARK_SHADE);
//	style->draw_rect(0, 0, width, height, GUICOLOR_DARK_SHADE);
	//style->draw_box(1, 1, width, height, GUICOLOR_DARK_SHADE, GUICOLOR_BRIGHT_SHADE);
	style->fill_rect(2, 2, width - 2, height - 2, GUICOLOR_WINDOW_NORMAL);
}

