/*
	$Id: popupmenu.cpp,v 1.27 2001/09/08 19:12:52 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "API/GUI/popupmenu.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"
#include "popupmenu_generic.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_PopupMenu::CL_PopupMenu(
	const CL_ComponentOptions &options,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_MenuData(options, parent, style),
	impl(NULL)
{
	impl = new CL_PopupMenu_Generic(this, options, style);
	get_style_manager()->connect_styles("popupmenu", options, this);
}

CL_PopupMenu::CL_PopupMenu(
	const CL_Point &pos,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_MenuData(
		CL_PopupMenu_Generic::create_options(pos),
		parent,
		style),
	impl(NULL)
{
	CL_ComponentOptions options = CL_PopupMenu_Generic::create_options(pos);
	impl = new CL_PopupMenu_Generic(this, options, style);
	get_style_manager()->connect_styles("popupmenu", options, this);
}

CL_PopupMenu::CL_PopupMenu(
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_MenuData(
		CL_PopupMenu_Generic::create_options(CL_Point()),
		parent,
		style),
	impl(NULL)
{
	CL_ComponentOptions options = CL_PopupMenu_Generic::create_options(CL_Point());
	impl = new CL_PopupMenu_Generic(this, options, style);
	get_style_manager()->connect_styles("popupmenu", options, this);
}

CL_PopupMenu::~CL_PopupMenu()
{
	delete impl;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

/////////////////////////////////////////////////////////////////////////////
// Operations:

/////////////////////////////////////////////////////////////////////////////
// Signals:

CL_Signal_v0 &CL_PopupMenu::sig_cancelled()
{
	return impl->sig_cancelled;
}
