/*
	$Id: combobox_generic.cpp,v 1.12 2001/12/27 23:14:03 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "combobox_generic.h"
#include "API/GUI/component_options.h"

CL_ComboBox_Generic::CL_ComboBox_Generic(CL_ComboBox *self)
: combobox(self)
{
	highlighted_item = 0;
	select_button = NULL;
	activated = false;

	slot_set_options = self->sig_set_options().connect(this, &CL_ComboBox_Generic::on_set_options);
}

CL_ComboBox_Generic::~CL_ComboBox_Generic()
{
}

int CL_ComboBox_Generic::get_count() const
{
	return items.size();
}

std::list<std::string> &CL_ComboBox_Generic::get_items()
{
	return items;
}

std::string CL_ComboBox_Generic::get_current_text() const
{
	int count = highlighted_item;
	std::list<std::string>::const_iterator it;
	for (it = items.begin(); it != items.end() && count > 0; it++, count--);
		if (it != items.end())
			return *it;

	char buf[100];
	sprintf(buf, "Listbox has illegal value: %d", highlighted_item);
	throw CL_Error(buf);
}

std::string CL_ComboBox_Generic::get_text(int index) const
{
	return "";
}

int CL_ComboBox_Generic::get_current_item() const
{
	return 0;
}

bool CL_ComboBox_Generic::is_selected(int index) const
{
	return false;
}

int CL_ComboBox_Generic::insert_item(const std::string &text, int index)
{
	return 0;
}

void CL_ComboBox_Generic::remove_item(int index)
{
}

void CL_ComboBox_Generic::change_item(const std::string &text, int index)
{
}

void CL_ComboBox_Generic::set_current_item(int index)
{
	highlighted_item = index;
	sig_highlighted(highlighted_item);
}

void CL_ComboBox_Generic::clear_selection()
{
}

void CL_ComboBox_Generic::sort(bool ascending)
{
}

void CL_ComboBox_Generic::clear()
{
}

void CL_ComboBox_Generic::set_select_button(CL_Button *_select_button)
{
	// TODO: Fix this:
/*	select_button = _select_button;
	slot_clicked = select_button->sig_clicked().connect(
		this, &CL_ComboBox_Generic::select_clicked);
	combobox->add_child(select_button, true);

	CL_ComponentOptions b_options;
	#ifdef BORLAND
		b_options.options.insert(std::make_pair(std::string("x"), std::string("0")));
		b_options.options.insert(std::make_pair(std::string("y"), std::string("0")));
		b_options.options.insert(std::make_pair(std::string("width"), std::string(CL_String(combobox->get_width()-select_button->get_width()))));
		b_options.options.insert(std::make_pair(std::string("height"), std::string(CL_String(combobox->get_height()))));
	#else
		b_options.options.insert(std::make_pair<std::string, std::string>("x", "0"));
		b_options.options.insert(std::make_pair<std::string, std::string>("y", "0"));
		b_options.options.insert(std::make_pair<std::string, std::string>("width", CL_String(combobox->get_width()-select_button->get_width())));
		b_options.options.insert(std::make_pair<std::string, std::string>("height", CL_String(combobox->get_height())));
	#endif

	CL_Button *text_area_button = new CL_Button(b_options, this);
	slot_pressed = text_area_button->sig_pressed.connect(
		this, &CL_ComboBox::select_clicked);
	add_child(text_area_button, true);
*/
}

void CL_ComboBox_Generic::select_clicked()
{
/*	if (skip_next_activation)
	{
		skip_next_activation = false;
		return;
	}
	activated = !activated;
	if (activated) sig_activated(highlighted_item);
*/
}

void CL_ComboBox_Generic::on_set_options(const CL_ComponentOptions &options)
{
	int num_values = options.count("value");
	for (int i = 0; i < num_values; i++)
		items.push_back(options.get_value("value", i));
}
