(in-package :sql)

(defun check-qualifier (qualifier)
  (if (consp qualifier)
      (case (length qualifier)
        (0 qualifier)
        (1 (first qualifier))
        (t (apply #'maisql-sys::sql-and qualifier)))
      qualifier))

(defun qualifier-functions (list)
  (mapcar (lambda (elt)
            `(when ,(car elt)
              (let ((term ,@(cdr elt)))
                (when term
                  (push term qualifier)))))
          list))

(defun qualifier-keywords (list)
  (mapcar #'car list))

(defmacro defquery ((&key function-name class-name ordering limit view-qualifier) &rest qualifiers)
  `(defun ,function-name (&key join all qualifier cursor
                          (row-limit ,limit) (order-by ,ordering) order-by-descending ,@(qualifier-keywords qualifiers))
     (flet ((%select (qualifier)
                     (when join
                       (push join qualifier))
                     (when ,view-qualifier
                       (push ,view-qualifier qualifier))
                     (let* ((and-qualifier (check-qualifier qualifier))
                            (args (list ',class-name
                                        :where and-qualifier
                                        :distinct t
                                        :order-by (and (not order-by-descending) order-by)
                                        :order-by-descending order-by-descending
                                        :limit row-limit)))
                       (values (apply #'select args)
                               args))))
       (unless (or all qualifier)
         ,@(qualifier-functions qualifiers))
       (multiple-value-bind (results args)
           (%select qualifier)
         (if cursor
             (make-instance 'sql-result-set
                            :rows results
                            :qualifier args)
             results)))))

(defclass sql-result-set ()
  ((index
    :initform 0)
   (sort
    :initform nil)
   (sort-fn
    :initform nil)
   (page-size
    :initform 30)
   (rows
    :initarg :rows
    :initform nil)
   (qualifier
    :initarg :qualifier
    :initform nil)))
