;;;; MaiSQL --- Common Lisp Interface Layer to SQL Databases
;;;; This is copyrighted software.  See documentation for terms.
;;;; 
;;;; dbms-interfacel.lisp --- Protocol for dbms interface layers
;;;; 
;;;; Checkout Tag: $Name:  $
;;;; $Id: dbms-interface.lisp,v 1.8 2001/02/13 17:06:29 jesse Exp $

(in-package :MAISQL-SYS)

(eval-when (:compile-toplevel :load-toplevel)


(defgeneric database-initialize-database-type (database-type)
  (:documentation
   "The internal generic implementation of initialize-database-type."))

(defgeneric database-type-load-foreign (database-type)
  (:documentation
   "Load associated external libraries for the given database-type."))

(defgeneric database-name-from-spec (connection-spec database-type)
  (:documentation
   "Returns the name of the database that would be created if connect
was called with the connection-spec."))

(defgeneric database-connect (connection-spec database-type)
  (:documentation "Internal generic implementation of connect."))

(defgeneric database-disconnect (database)
  (:documentation "Internal generic implementation of disconnect."))

(defgeneric database-query (query-expression database)
  (:documentation "Internal generic implementation of query."))

(defgeneric database-execute-command (sql-expression database)
  (:documentation "Internal generic implementation of execute-command."))

;;; Mapping and iteration
(defgeneric database-query-result-set
    (query-expression database &optional full-set)
  (:documentation
   "Internal generic implementation of query mapping.  Starts the
query specified by query-expression on the given database and returns
a result-set to be used with database-store-next-row and
database-dump-result-set to access the returned data.  The second
value is the number of columns in the result-set, if there are any.
If full-set is true, the number of rows in the result-set is returned
as a third value.  This might have memory and resource usage
implications, since many databases will require the query to be
executed in full to answer this question.  If the query produced no
results then nil is returned for all values that would have been
returned otherwise.  If an error occurs during query execution, the
function should signal a maisql-sql-error."))


(defgeneric database-dump-result-set (result-set database)
  (:documentation "Dumps the received result-set."))

(defgeneric database-store-next-row (result-set database list)
  (:documentation
   "Returns t and stores the next row in the result set in list or
returns nil when result-set is finished."))

(defgeneric database-create-sequence (name database)
  (:documentation "Create a sequence in DATABASE."))

(defgeneric database-drop-sequence (name database)
  (:documentation "Drop a sequence from DATABASE."))

(defgeneric database-sequence-next (name database)
  (:documentation "Increment a sequence in DATABASE."))

(defgeneric database-start-transaction (database)
  (:documentation "Start a transaction in DATABASE."))

(defgeneric database-commit-transaction (database)
  (:documentation "Commit current transaction in DATABASE."))

(defgeneric database-abort-transaction (database)
  (:documentation "Abort current transaction in DATABASE."))

(defgeneric database-get-type-specifier (type args database)
  (:documentation "Return the type SQL type specifier as a string, for
the given lisp type and parameters."))

(defgeneric database-list-tables (database &key (system-tables nil))
  (:documentation "List all tables in the given database"))

(defgeneric database-list-attributes (table database)
  (:documentation "List all attributes in TABLE."))

(defgeneric database-attribute-type (attribute table database)
  (:documentation "Return the type of ATTRIBUTE in TABLE."))

(defgeneric database-add-attribute (table attribute database)
  (:documentation "Add the attribute to the table."))

(defgeneric database-rename-attribute (table oldatt newname database)
  (:documentation "Rename the attribute in the table to NEWNAME."))

(defgeneric oid (object)
  (:documentation "Return the unique ID of a database object."))

)                                       ; eval-when
