;; -*- Mode: Lisp -*-
;; $Id: makefile.lisp,v 1.4 2001/10/03 20:50:27 apharris Exp $

(format t ";; Making USQL fasl file~%")

(defparameter *sql-sources*
  '("sql/package"
    "sql/dbms-interface"
    "sql/classes"
    "sql/operations"
    "sql/syntax"
    "sql/sql"
    "sql/table"
    "sql/conditions"
    "sql/recording"
    "sql/transaction"
    "sql/metaclasses"
    "sql/objects"
    "sql/schema"
    "sql/pools"
    "sql/queries"
    "dbms-loader"
;;    "dbms/oracle/system"
;;    "dbms/oracle/oracle-package"
;;    "dbms/oracle/oracle-loader"
;;    "dbms/oracle/oracle-constants"
;;    "dbms/oracle/oracle"
;;    "dbms/oracle/oracle-sql"
;;    "dbms/postgresql/system"
    "dbms/postgresql/postgresql-package"
    "dbms/postgresql/postgresql-loader"
;;    "dbms/postgresql/postgresql"
    "dbms/postgresql/postgresql-sql"
    ))

(let ((files (mapcar (lambda (file)
		       (merge-pathnames file "*.lisp"))
		     *sql-sources*)))
  (compile-file files
                :load t
		:output-file "usql-library.x86f"
		:error-file "usql-library.err"))

(quit)