;;; -*- Mode: Lisp -*-
;;;; 
;;;; pgsql-ffc.lisp --- Lispworks FFI interface to PostgreSQL.
;;;; 
;;;; Checkout Tag: $Name:  $
;;;; $Id: ffi-lispworks.lisp,v 1.2 2001/02/08 22:21:46 jesse Exp $

(in-package :MAISQL-POSTGRESQL)

;;;; %File Description:
;;;; 
;;;; As similar to postgresql-ffc.lisp as I can get it, with CMUCL
;;;; foreign bindings replaced with Lispwork equivalents.
;;;; 
;;;; W:STR seems to work pretty well for returning C strings from, but not to, foreign
;;;; functions.  Oh well, fli:with-dynamic-foreign-objects et. al. works quite well,
;;;; but makes maintining a bit more difficult as I have to keep two copies of all the
;;;; low level functionality-  one for cmucl, one for Lispworks.

;;;; Alien Type definitions

(deftype psql-conn-ptr ()
  `fli::pointer)

(deftype psql-result-ptr ()
  `fli::pointer)

;;; Basic Types
(fli:define-c-typedef psql-oid (:unsigned :int))

(fli:define-c-enum psql-conn-status-type :connection-ok :connection-bad)

(fli:define-c-enum psql-exec-status-type  :empty-query
  :command-ok
  :tuples-ok
  :copy-out
  :copy-in
  :bad-response
  :nonfatal-error
  :fatal-error)

(fli:define-c-typedef psql-conn (:pointer :void))

(fli:define-c-typedef psql-result (:pointer :void))

(fli:define-foreign-function
    (pqconnectdb "PQconnectdb" :source)
    ((conninfo :pointer))
  :result-type psql-conn
  :language :ansi-c)

(fli:define-foreign-function 
    (pqsetdblogin "PQsetdbLogin")
    ((pghost :pointer)
     (pgport :pointer) 
     (pgoptions :pointer) 
     (pgtty :pointer) 
     (dbName :pointer)
     (login :pointer)
     (pwd :pointer))
  :result-type psql-conn
  :language :ansi-c)


(fli:define-foreign-function 
    (pqfinish "PQfinish" :source)
    ((conn psql-conn))
  :result-type :void
  :language :ansi-c)

(fli:define-foreign-function 
    (pqstatus "PQstatus" :source)
    ((conn psql-conn))
  :result-type psql-conn-status-type
  :language :ansi-c)

(fli:define-foreign-function 
    (pqerrormessage "PQerrorMessage" :source)
    ((conn psql-conn))
  :result-type (:ef-mb-string :limit 4096)
  :language :ansi-c)

(fli:define-foreign-function 
    (pqexec "PQexec" :source)
    ((conn psql-conn)
     (query :pointer))
  :result-type psql-result
  :language :ansi-c)

(fli:define-foreign-function 
    (pqresultstatus "PQresultStatus" :source)
    ((res psql-result))
  :result-type psql-exec-status-type  
  :language :ansi-c)

(fli:define-foreign-function 
    (pqntuples "PQntuples" :source)
    ((res psql-result))
  :result-type :int
  :language :ansi-c)

(fli:define-foreign-function 
    (pqnfields "PQnfields")
    ((res psql-result))
  :result-type :int
  :language :ansi-c)

(fli:define-foreign-function 
    (pqfname "PQfname" :source)
    ((res psql-result)
     (field-num :int))
  :result-type (:ef-mb-string :limit 4096)
  :language :ansi-c)

(fli:define-foreign-function 
    (pqfnumber "PQfnumber" :source)
    ((res psql-result)
     (field-name :pointer))
  :result-type :int
  :language :ansi-c)

(fli:define-foreign-function 
    (pqftype "PQftype" :source)
    ((res psql-result)
     (field-num :int))
  :result-type psql-oid
  :language :ansi-c)

(fli:define-foreign-function 
    (pqfsize "PQfsize" :source)
    ((res psql-result)
     (field-num :int))
  :result-type :short
  :language :ansi-c)

(fli:define-foreign-function 
    (pqcmdstatus "PQcmdStatus" :source)
    ((res psql-result))
  :result-type (:ef-mb-string :limit 4096)
  :language :ansi-c)

(fli:define-foreign-function 
    (pqoidstatus "PQoidStatus" :source)
    ((res psql-result))
  :result-type (:ef-mb-string :limit 4096)
  :language :ansi-c)

(fli:define-foreign-function 
    (pqcmdtuples "PQcmdTuples" :source)
    ((res psql-result))
  :result-type (:ef-mb-string :limit 4096)
  :language :ansi-c)

(fli:define-foreign-function 
    (pqgetvalue "PQgetvalue" :source)
    ((res psql-result)
     (tup-num :int)
     (field-num :int))
  :result-type (:ef-mb-string :limit 4096)
  :language :ansi-c)

(fli:define-foreign-function 
    (pqgetlength "PQgetlength" :source)
    ((res psql-result)
     (tup-num :int)
     (field-num :int))
  :result-type :int
  :language :ansi-c)

(fli:define-foreign-function 
    (pqgetisnull "PQgetisnull" :source)
    ((res psql-result)
     (tup-num :int)
     (field-num :int))
  :result-type :boolean
  :language :ansi-c)

(fli:define-foreign-function 
    (pqclear "PQclear" :source)
    ((res psql-result))
  :result-type :void
  :language :ansi-c)

(fli:define-foreign-function
    (pqisbusy "PQisBusy" :source)
    ((conn psql-conn))
  :result-type :int
  :language :ansi-c)


(defun test-psql ()
  (fli:with-dynamic-foreign-objects ()
    (let ((host (fli:convert-to-dynamic-foreign-string "localhost"))
          (port (fli:convert-to-dynamic-foreign-string "5432"))
          (null-str (fli:convert-to-dynamic-foreign-string NIL))
          (user (fli:convert-to-dynamic-foreign-string "jmiller1"))
          (dbname (fli:convert-to-dynamic-foreign-string "casa_dev"))
          (exec-tst (fli:convert-to-dynamic-foreign-string 
                     "SELECT * from Projects;"))
          conn res)
      (setq conn (pqsetdblogin host port null-str null-str dbname user null-str))
      (format t "Connection status = ~A~%" (pqstatus conn))
      (setq res (pqexec conn exec-tst))
      (format t "Exec result = ~A~%" (pqcmdstatus res))
      (format t "Error messages (if any) = ~A~%" (pqerrormessage conn))
      (pqfinish conn))))

