;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: wcof -*-
;;; $Id: symbol.lisp,v 1.4 2001/11/14 16:27:21 jesse Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.

(in-package :odcl)

(defun ensure-keyword (name)
  "return the keyword corresponding to NAME, which may be a keyword,
string or symbol"
  (etypecase name
    (string (values (intern (string-upcase name) :keyword)))
    (keyword    name)
    (symbol  (values (intern (string-upcase (symbol-name name)) :keyword)))))

(defun keyword->symbol (symbol)
  (when (typep symbol 'keyword)
    (values (intern (symbol-name symbol)))))

(defun symconcat (package &rest args)
  "Create a symbol in PACKAGE named by the concatenation of ARGS"
  (flet ((stringify (arg)
           (etypecase arg
             (string
              (string-upcase arg))
             (symbol
              (symbol-name arg)))))
    (intern (string-upcase (apply #'concatenate 'string (mapcar #'stringify args))) package)))

