;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: wcof -*-
;;; $Id: numbers.lisp,v 1.3 2001/11/12 19:52:56 jesse Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.

(in-package :odcl)

(defun parse-integer-insensitively (string)
  (flet ((digit-char-p (char)
           (position char "1234567890")))
    (let ((start (position-if #'digit-char-p string))
          (end   (position-if #'digit-char-p string :from-end t)))
      (when (and start end)
        (parse-integer (subseq string start (1+ end)) :junk-allowed t)))))

(defun ensure-integer (integer)
  "tries to coerce the argument to an integer, returning nil on failure"
  (typecase integer
    (integer integer)
    (string (values (parse-integer-insensitively integer)))))
