;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: network.lisp,v 1.5 2002/03/29 04:23:43 craig Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.

(in-package :odcl)

;; internet address to string

(defun ip-address-string (address)
  (if address
      (format nil "~D.~D.~D.~D"
              (ldb (byte 8 24) address)
              (ldb (byte 8 16) address)
              (ldb (byte 8 8)  address)
              (ldb (byte 8 0)  address))
      "0.0.0.0"))

#+cmu
(defun local-host-name ()
  (let ((output (make-string-output-stream))
        (errors (make-string-output-stream)))
    (ext:run-program "hostname" '("--fqdn")
                     :wait t
                     :error errors
                     :output output)
    (string-trim "
" (get-output-stream-string output))))

