;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: locale.lisp,v 1.2 2002/01/09 21:25:44 jesse Exp $
;;;
;;; Copyright (c) 2001 onShore Development, Inc.

(in-package :odcl)

(defvar *lang* '((:en)))
(defvar *country* :US)

(defvar *msgs* (make-hash-table))

(defun gettext (text)
  (dolist (lang *lang*)
    (when-bind (lang (gethash (car lang) *msgs*))
      (when-bind (text (gethash text lang))
        (return-from gettext text))))
  text)

(eval-when (:compile-toplevel :load-toplevel)

(set-dispatch-macro-character
 #\#
 #\I
 #'(lambda(s c n)
     (declare (ignore c n))
     (let ((string (read s nil (values) t)))  ;list is object after #n{
       `(gettext ,string)))))


(defun y-n-string (boolean)
  (if boolean
      #i"Yes"
      #i"No"))

(defun parse-lc (locale)
  (let ((lang (subseq locale 0 2))
        (country (subseq locale 3 5)))
    (list (intern (string-upcase lang) :keyword)
          (intern (string-upcase country) :keyword))))

(defun addtext (msgid locale msg)
  (destructuring-bind (lang country)
      (parse-lc locale)
    (declare (ignore country))
    (let ((msgs (gethash lang *msgs*)))
      (unless msgs
        (setf msgs (make-hash-table :test #'equal)
              (gethash lang *msgs*) msgs))
      (setf (gethash msgid msgs) msg))))
    
(addtext "Yes" "de_DE" "Ja")
(addtext "No" "de_DE" "Nein")
(addtext "Yes" "fr_FR" "Oui")
(addtext "No" "fr_FR" "Non")

