;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: tabbed-dialog.lisp,v 1.12 2002/02/20 05:55:18 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)

;; ------------------------------------------------------------
;; component: tabbed-dialog

(defclass tabbed-dialog (html-element)
  ((title
    :initform "Tabbed Dialog"
    :initarg :title)
   (tabs
    :initform nil)
   (visible-tab
    :initform nil))
  (:documentation
   "like a windoze tabbed-dialog: show distinct groups of details for something"))

(defmethod render-html ((self tabbed-dialog) stream)
  (html-stream
   stream
   ((:table :border 0 :cellpadding 0 :cellspacing 0 :width "100%")
    (:tr
     ((:td :bgcolor "#dddddd" :valign :top)
      (write-spacer stream)))
    ((:tr :valign "top")
     (:td
      ((:table :cellpadding 0 :cellspacing 0 :bgcolor "#888888" :border 0 :width "100%")
       (:tbody
        (:tr
         ((:td :width 2)
          (write-spacer stream))
         (draw-dialog-tabs self stream)
         ((:td :width "100%" :align :center :bgcolor "#888888" :class "top_bar")
          "&nbsp;"))))))
    ((:tr :valign :top)
     (:td
      (draw-dialog-body self stream))))))

(defun ensure-tab (element tab)
  (let ((child (child-element element tab :if-does-not-exist t)))
    (if (null child)
        (setf (child-element element tab)
              (session-instance tab))
        child)))

(defmethod preawake ((self tabbed-dialog))
  (with-slots (visible-tab tabs)
    self
    (setf tabs (get-available-tabs self))
    (when (null visible-tab)
      (setf visible-tab (get-default-tab self)))
    (when visible-tab
      (let ((visible (ensure-tab self visible-tab)))
        (setf (element-value visible)
              (element-value self))
        (preawake visible)))))
  
(defmethod awake ((self tabbed-dialog))
  (with-slots (visible-tab)
    self
    (awake (ensure-tab self visible-tab))))
  
(defmethod draw-dialog-body ((self tabbed-dialog) stream)
  (render-html (child-element self (slot-value self 'visible-tab))
               stream))

(defmethod draw-dialog-tabs ((self tabbed-dialog) stream)
  (with-slots (tabs visible-tab)
    self
    (html-stream
     stream
     (:td
      ((:img :width 1 :height 24 :alt "" :src (local-href "images/spacer.gif"))))
     (dolist (tab tabs)
       (if (equal visible-tab (car tab))
           (html-stream
            stream
            ((:td :width 10 :height 24 :valign :top :align :center :bgcolor "yellow" :class "top_bar")
             ((:img :alt "" :src (local-href "images/tab-left.gif"))))
            ((:td :align :center :bgcolor "yellow" :class "top_bar")
             ((:font :color "black")
              (write-string (cdr tab) stream)))
            ((:td :width 10 :valign :top :align :center :bgcolor "yellow" :class "top_bar")
             ((:img :border 0 :alt "" :src (local-href "images/tab-right.gif")))))
           (html-stream
            stream
            ((:td :width 10 :valign :top :align :center :bgcolor "#aaaaaa" :class "top_bar")
             ((:img :alt "" :src (local-href "images/tab-left.gif"))))
            
            ((:td :align :center :bgcolor "#aaaaaa" :class "top_bar")
             ((:font :color "#ffffff")
              (with-action (stream self choose-tab (symbol-name (car tab)))
                (write-string (cdr tab) stream))))
            ((:td :width 10 :valign :top :align :center :bgcolor "#aaaaaa" :class "top_bar")
             ((:img :alt "" :src (local-href "images/tab-right.gif"))))
            ((:td :width 1 :align :center :bgcolor "#888888" :class "top_bar")
             ((:img :width 1 :height 24 :alt "" :src (local-href "images/spacer.gif"))))))))))

(define-wm choose-tab ((self tabbed-dialog) (tab string))
  (with-slots (tabs visible-tab)
    self
    (setf visible-tab (intern tab :wco)))
  nil)

