;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: socket.lisp,v 1.26 2002/02/22 21:50:19 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)

(defun read-int (stream &aux (integer 0))
  (setq integer (dpb (read-byte stream) (byte 8 24) integer))
  (setq integer (dpb (read-byte stream) (byte 8 16) integer))
  (setq integer (dpb (read-byte stream) (byte 8 8) integer))
  (dpb (read-byte stream) (byte 8 0) integer))

(defun read-int16 (stream)
  (declare (optimize (speed 3)))
  (logior (ash (the (unsigned-byte 8) (read-byte stream)) 8)
          (the (unsigned-byte 8) (read-byte stream))))

(defconstant *jserv-empty-string* (- (ash 1 16) 1))
  
(defun read-string (stream)
  "Check string length against (ash 1 16) before consing ... duh"
  (let ((length (read-int16 stream)))
    (if (= length *jserv-empty-string*)
        nil
        (let ((string (make-string length)))
          (dotimes (x length)
            (setf (aref string x) (code-char (read-byte stream))))
          string))))

(defun read-length-bytes (stream)
  (let* ((length (read-int16 stream))
         (buffer (make-array length :element-type '(unsigned-byte 8))))
    (dotimes (x length)
      (setf (aref buffer x) (read-byte stream)))
    (values buffer length)))

(defun write-length-bytes (buffer stream)
  (write-int16 (length buffer) stream)
  (dotimes (x (length buffer))
    (write-byte (aref buffer x) stream)))

;;
;; Writers
;;

(defun write-int64 (int stream)
  (write-byte (ldb (byte 8 56) int) stream)
  (write-byte (ldb (byte 8 48) int) stream)
  (write-byte (ldb (byte 8 40) int) stream)
  (write-byte (ldb (byte 8 32) int) stream)
  (write-byte (ldb (byte 8 24) int) stream)
  (write-byte (ldb (byte 8 16) int) stream)
  (write-byte (ldb (byte 8 8) int) stream)
  (write-byte (ldb (byte 8 0) int) stream))
  
(defun write-int (int stream)
  (write-byte (ldb (byte 8 24) int) stream)
  (write-byte (ldb (byte 8 16) int) stream)
  (write-byte (ldb (byte 8 8) int) stream)
  (write-byte (ldb (byte 8 0) int) stream))
  
(defun write-int16 (int stream)
  (declare (optimize (speed 3))
	   (type (unsigned-byte 16) int))
  (write-byte (ldb (byte 8 8) int) stream)
  (write-byte (ldb (byte 8 0) int) stream))
  
(defun cgi-write-string (string stream)
  (dotimes (x (length string))
    (write-byte (char-code (aref string x)) stream)))

(defun cgi-write-length-string (string stream)
  (write-int16 (length string) stream)
  (dotimes (x (length string))
    (write-byte (char-code (aref string x)) stream)))
