;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: makefile.lisp,v 1.9 2002/01/16 19:04:56 apharris Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(setf *compile-print* nil)
(setf *compile-verbose* nil)

;; defsystem behaves like make now, and quieter even
(setf make::*compile-during-load* t)
(setf make::*oos-verbose* nil)

;; inhibit all notes and most non-serious warnings
#+cmu
(declaim (optimize (inhibit-warnings 2)))

(handler-case 
    (progn
      (with-compilation-unit ()
        (mk:oos :imho :compile :verbose nil)
        (compile-file (mk:files-in-system :imho)
                      :output-file "imho.fasl"
                      :error-file "imho.err"))
      
      (quit))
  (error (e)
    (progn
      (format t "Error: ~A" e)
      (unix:unix-exit 1))))

