;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: browser.lisp,v 1.5 2002/02/19 16:38:32 craig Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)

;; check a browser capability
(defvar *browsers*
  nil)

(defun browser-property (property)
  "not used anywhere"
  (let ((agent (get-header-value *active-request* :user-agent)))
    ;;(setf agent (parse-agent agent))
    (member property (cdr (assoc agent *browsers*)))))

(defun parse-agent (agent &aux base attrs)
  (let ((pos (position #\( agent)))
    (if pos
        (setf base (subseq agent 0 (1- pos))
              attrs (split (subseq agent (1+ pos) (1- (length agent))) #\;))
        (setf base agent)))
  (list base attrs))


#|
 121277 Mozilla/4.0 (compatible; MSIE 4.01; Windows 98)
 119546 Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)
 119033 Mozilla/4.0 (compatible; MSIE 4.0; Windows 95)
 110693 Mozilla/3.0 (compatible; MSIE 3.0)
  97114 Mozilla/2.0 (compatible; MSIE 3.02; Update a; Windows 95)
  94184 Mozilla/4.04 [en] (Win95; I)
  79309 Mozilla/3.0 (Win95; I)
  61271 Mozilla/2.0 (compatible; MSIE 3.01; Windows 95)
  61214 Teleport Pro/1.28
  58402 Mozilla/2.0 (compatible; MSIE 3.0; Windows 95)
  55084 Mozilla/4.05 [en] (Win95; I)
  39879 Mozilla/4.0 (compatible; MSIE 4.01; Windows NT)
  39485 Mozilla/2.0 (compatible; MSIE 3.02; Windows 95)
  32486 Arkanavt/1.02.015 (compatible; Win16; I)
  31868 Mozilla/4.03 [en] (Win95; I)
  29425 Teleport Pro/1.29
  27537 Mozilla/4.01 [en] (Win95; I)
  25959 Mozilla/3.01 (Win95; I)
  25100 Mozilla/3.01Gold (Win95; I)
  21457 Mozilla/2.02 (OS/2; I)
  20410 Mozilla/3.01 (WinNT; I)
  19758 WebZIP/2.32 (http://www.spidersoft.com)
  18604 Mozilla/3.0 (Win95; I; HTTPClient 1.0)
  17280 IBM-WebExplorer-DLL/v1.2 
  17027 Mozilla/4.0 [en] (Win95; I)
  17010 Mozilla/2.0 (compatible; MSIE 3.02; Update a; AK; Windows 95)
  16915 Mozilla/2.0 (compatible; MSIE 3.02; AK; Windows 95)
  16897 Mozilla/3.0
  16082 Mozilla/4.0 (compatible; MSIE 4.0; Windows NT)
  15107 Mozilla/4.04 [en] (WinNT; I)
|#