#include "cp_types.h"
#include "cp_proto.h"
#include "cp_post.h"

int dum_int;

int post_s_tri(FILE *fp,complex p1,complex p2,complex p3,
	       int fflag,int ecol,int col)
     /* post a sph triangle */
{
  struct Pathlist *list;

  if ((list=sph_tri_list(p1,p2,p3,num_plot))==NULL) return 0;
  return post_s_convex(fp,list,fflag,ecol,col);
} /* post_s_tri */

int post_s_convex(FILE *fp,struct Pathlist *slist,
		  int eflag,int ecol,int col)
     /* sph tri, convex circle, convex polygon. A 'closepath'
	will be issued when 'filled' is specified. */
{
  int i=1,k;
  struct Pathlist *trace;

  if (slist==NULL || (slist=fix_convex_list(slist))==NULL) return 0;
  trace=slist;
  while (trace->next!=NULL && i<10000)
    {
      i++;
      trace=trace->next;
    }
  trace=slist;
  fprintf(fp,"gs n %f %f m\n",trace->x,trace->y);
  for (k=2;k<=i;k++)
    {
      trace=trace->next;
      fprintf(fp,"%f %f l\n",trace->x,trace->y);
    }
  if (ecol!=FG_COLOR) /* edge colors? */
    fprintf(fp,"%f %f %f srgb ",
	    (double)red[ecol]/255,(double)green[ecol]/255,
	    (double)blue[ecol]/255);
  if ((eflag & 2) && col!=FG_COLOR) 
    fprintf(fp,"cp\ngs %f %f %f srgb fill gr ",
	    (double)red[col]/255,(double)green[col]/255,
	    (double)blue[col]/255);
  else if (eflag & 2)
    fprintf(fp,"cp\ngs gry  sg fill gr\n");
  fprintf(fp,"s gr\n");
  path_free(&slist);
  return 1;
} /* post_s_convex */

int post_s_geo(FILE *fp,struct s_data *screen,complex z1,complex z2)
     /* store spherical geo */
{
  int length=1,k;
  struct Pathlist *trace,*plist=NULL;

  if ((plist=s_geodesic(ss_view(screen,z1,1,&dum_int),
			ss_view(screen,z2,1,&dum_int),num_plot))==NULL) 
    return 0;
  trace=plist;
  while ((trace->next)!=NULL)
    {trace=trace->next;length++;}
  trace=plist;
  fprintf(fp,"n\n %f %f m\n",trace->x,trace->y);
  for (k=1;k<=length && (trace=trace->next)!=NULL;k++)
    fprintf(fp,"%f %f l\n",trace->x,trace->y);
  fprintf(fp,"s\n");
  path_free(&plist);
  return 1;
} /* post_s_geo */

int post_s_cir(FILE *fp,double rad,complex ctr,int cflag,int ccol,int col)
     /* post spherical circle. */
{
  struct Pathlist *list;

  if ((list=s_circle_list(ctr,rad,num_plot))==NULL) return 0;
  return post_s_convex(fp,list,cflag,ccol,col);
} /* post_s_cir */

int post_equator(FILE *fp,struct s_data *q)
     /* spherical unit circle, screen q, std width */
{
  int n;
  complex ctr;

  ctr.re=0.0;ctr.im=M_PI;
  fprintf(fp,"gs %f ourlinewidth\n",PS_UNIT_LINEWIDTH);
  n=post_s_cir(fp,M_PI_2,ss_view(q,ctr,1,&dum_int),
		    0,FG_COLOR,FG_COLOR);
  fprintf(fp," gr\n");
  return n;
} /* post_equator */
	
