#include "cp_types.h"
#include "cp_proto.h"

/* add layer of nodes to bdry nodes of pack p,
from v1 to v2, degree n. Return number of new vertices added. flag
returns 0 if at least one node ends up with more than n neighbors. 
Already checked that v1 and v2 are nodes in same bdry component.  */

int add_layer(struct p_data *p,int v1,int v2,int n,int *flag)
{
  int count=0,need,vert,nextvert,i;
	
  *flag=1;
  if (v2==v1) v2=p->packK_ptr[v2].flower[p->packK_ptr[v2].num];
  vert=v1;
  nextvert=p->packK_ptr[vert].flower[0];
  while (vert!=v2 && p->packK_ptr[vert].bdry_flag)	
    /* go until you get to v2 */
    {
      if (n<p->packK_ptr[vert].num) *flag=0;
      else if ((need=n-p->packK_ptr[vert].num-1)>0)
	for (i=1;i<=need;i++)
	  count += add_vert(p,vert);
      enfold(p,vert);
      vert=nextvert;
      nextvert=p->packK_ptr[vert].flower[0];
    }
  if (vert==v2 && p->packK_ptr[v2].bdry_flag) /* now do v2 itself */
    {
      if (n<p->packK_ptr[vert].num) *flag=0;
      else if ((need=n-p->packK_ptr[vert].num-1)>0)
	for (i=1;i<=need;i++)
	  count += add_vert(p,vert);
      enfold(p,vert);
    }
  if (p->packK_ptr[v1].num>n || p->packK_ptr[v2].num>n) *flag=0;
  complex_count(p,0);
  facedraworder(p,0);
  set_aim_default(p);
  choose_beta(p);
  return count;
} /* add_layer */
