/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1998 Spencer Kimball and Peter Mattis
 *
 * Time-stamp: <1999/11/12 10:13:51 narazaki@gimp.org>
 *
 * debug.h -- This file is a part of guash.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef DEBUG
static gint	debug_level = 0;
#ifdef DEBUG_SUPPRESS_LEVEL
static gint	debug_suppress_level_default  = DEBUG_SUPPRESS_LEVEL;
static gint	debug_suppress_level = DEBUG_SUPPRESS_LEVEL;
#else
static gint	debug_suppress_level_default  = 8;
static gint	debug_suppress_level = 8;
#endif
static gint
debug_message_header (gint i, gint suppress)
{
  if (i < 0)
    {
      debug_level += i;
      if (debug_level < 0)
	debug_level = 0;
      if (debug_level < debug_suppress_level)
	{
	  debug_suppress_level = debug_suppress_level_default;
	  return TRUE;
	}
      else
	return FALSE;
    }
  else
    {
      gint j;

      debug_level += i;

      if (suppress == 2)
	{
	  if (debug_level < debug_suppress_level)
	    debug_suppress_level = debug_level;
	  return FALSE;
	}
      else if (debug_level < debug_suppress_level)
	{
	  for (j = 1; j < debug_level; j++)
	    printf (" ");
	  if (0 == i)
	    printf ("|");

	  if (0 < suppress)
	    debug_suppress_level = debug_level;
	  
	  return TRUE;
	}
      else
	return FALSE;
    }
}
# define DEBUGBLOCK	if (debug_message_header (1, 0)) printf
# define _DEBUGBLOCK	if (debug_message_header (1, 1)) printf
# define __DEBUGBLOCK	if (debug_message_header (1, 2)) printf
# define DPRINT		if (debug_message_header (0, 0)) printf
# define _DPRINT	if (0) printf
# define DPRINTIF(exp)	if ((exp) && debug_message_header (0, 0)) printf
# define DEBUGEND	debug_message_header (-1, 0)
# define RETURN		if (debug_message_header (-1, 0) || 1) return
#else
# define DEBUGBLOCK	if (0) printf
# define _DEBUGBLOCK	if (0) printf
# define __DEBUGBLOCK	if (0) printf
# define DPRINT		if (0) printf
# define _DPRINT	if (0) printf
# define DPRINTIF(exp)	if (0) printf
# define DEBUGEND	;
# define RETURN		return
#endif

#if defined(DEBUG) || defined(DEATH_ATTACK)
# define G_ASSERT	g_assert
# undef g_malloc
# define g_malloc malloc
# define g_free free
#else
#define	G_ASSERT(exp)	;
#endif
