/*
 * Distributor.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  Distributor.hpp
   
  Utility to communicate between several top windows (more general:
  between classes). See "Distributor.hpp"
*/

#include <cstdio>
#include "Distributor.hpp"

//==========================
// DistributorBase...
//==========================
//
// double logins of the same function are not prevented; would lead to
// (undangerous) multiple calls
//
void DistributorBase::login (Callback* fp, void* user)
{
  array_.push_back (Entry(fp,user));
  printf("DistributorBase::%s(): size()=%d\n", __func__, array_.size());
  //report(0);
}

//
// logout of a non-registered or already removed Callback or User is harmless
//  
void DistributorBase::logout (Callback* fp)
{
  for (unsigned i=0; i < array_.size(); i++) {
    if (array_[i].fp == fp) {
      array_.erase (array_.begin()+i);
      printf("DistributorBase::%s(): size()=%d\n", __func__, array_.size());
      return;
    }
  }
  printf("DistributorBase::%s(callback=%p: not found): size()=%d\n", __func__, fp, array_.size());
}

void DistributorBase::logout (void* user)
{
  for (unsigned i=0; i < array_.size(); i++) {  
    if (array_[i].user == user) {
      array_.erase (array_.begin()+i);
      printf("DistributorBase::%s(): size()=%d\n", __func__, array_.size());
      return;
    }
  }
  printf("DistributorBase::%s(user=%p: not found): size()=%d\n", __func__, user, array_.size());
}

void DistributorBase::report (const char* label) const
{
  printf("\"%s\"-Distributor-Report:\n", label);
  for (unsigned i=0; i < array_.size(); i++)
    printf("\t%d: callback = %p,  user = %p\n", i, array_[i].fp, array_[i].user);
}


// END OF FILE
